/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.events;

import java.util.HashMap;
import java.util.Map;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class PlayerInteract
implements Listener {
    private final ToolStats toolStats;
    public final Map<Block, Player> openedChests = new HashMap<Block, Player>();
    public final Map<StorageMinecart, Player> openedMineCarts = new HashMap<StorageMinecart, Player>();

    public PlayerInteract(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        BlockState state = block.getState();
        if (state instanceof InventoryHolder) {
            this.openedChests.put(block, player);
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> this.openedChests.remove(block), 20L);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent event) {
        Entity clicked = event.getRightClicked();
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE && !this.toolStats.config.getBoolean("allow-creative")) {
            return;
        }
        if (clicked.getType() == EntityType.CHEST_MINECART) {
            StorageMinecart storageMinecart = (StorageMinecart)clicked;
            this.openedMineCarts.put(storageMinecart, player);
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.toolStats, scheduledTask -> this.openedMineCarts.remove(storageMinecart), 20L);
        }
    }
}

