/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.hyperlib.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.hyper.toolstats.hyperlib.HyperLib;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class TextUtils {
    private final HyperLib hyperLib;
    public final Pattern COLOR_CODES = Pattern.compile("[&\u00a7]([0-9a-fk-or])");
    public final Pattern HEX_PATTERN = Pattern.compile("[&\u00a7]#([A-Fa-f0-9]{6})");

    public TextUtils(HyperLib hyperLib) {
        this.hyperLib = hyperLib;
    }

    public Component format(String input) {
        if (input.isEmpty()) {
            return Component.empty();
        }
        Matcher hexMatcher = this.HEX_PATTERN.matcher(input);
        Matcher colorMatcher = this.COLOR_CODES.matcher(input);
        Object component = hexMatcher.find() || colorMatcher.find() ? LegacyComponentSerializer.legacyAmpersand().deserialize(input) : this.hyperLib.getMiniMessage().deserialize((Object)input);
        return component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public Component formatMultiLine(List<String> lines) {
        TextComponent component = Component.empty();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            component = i == lines.size() - 1 ? component.append(this.format(line)) : component.append(this.format(line)).append((Component)Component.newline());
        }
        return component;
    }
}

