/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import lol.hyper.toolstats.ToolStats;
import org.bukkit.Material;

public class HashMaker {
    private final ToolStats toolStats;

    public HashMaker(ToolStats toolStats) {
        this.toolStats = toolStats;
    }

    public String makeHash(Material itemType, UUID player, long timestamp) {
        String input = itemType.toString() + player.toString() + timestamp;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException exception) {
            this.toolStats.logger.error("Unable to generate hash", (Throwable)exception);
            this.toolStats.logger.warn("Unable to generate hash for {}!", (Object)player);
            this.toolStats.logger.warn("Generating a random UUID instead.");
            return UUID.randomUUID().toString();
        }
    }
}

