/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.toolstats.tools;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lol.hyper.toolstats.ToolStats;

public class NumberFormat {
    private DecimalFormat DECIMAL_FORMAT;
    private DecimalFormat COMMA_FORMAT;
    private SimpleDateFormat DATE_FORMAT;

    public NumberFormat(ToolStats toolStats) {
        String dateFormat = toolStats.config.getString("date-format");
        String decimalSeparator = toolStats.config.getString("number-formats.decimal-separator");
        String commaSeparator = toolStats.config.getString("number-formats.comma-separator");
        String commaFormat = toolStats.config.getString("number-formats.comma-format");
        String decimalFormat = toolStats.config.getString("number-formats.decimal-format");
        if (dateFormat == null) {
            dateFormat = "M/dd/yyyy";
            toolStats.logger.warn("date-format is missing! Using default American English format.");
        }
        if (decimalSeparator == null) {
            decimalSeparator = ".";
            toolStats.logger.warn("number-formats.decimal-separator is missing! Using default \".\" instead.");
        }
        if (commaSeparator == null) {
            commaSeparator = ",";
            toolStats.logger.warn("number-formats.comma-separator is missing! Using default \",\" instead.");
        }
        if (commaFormat == null) {
            commaFormat = "#,###";
            toolStats.logger.warn("number-formats.comma-format is missing! Using default #,### instead.");
        }
        if (decimalFormat == null) {
            decimalFormat = "#,##0.00";
            toolStats.logger.warn("number-formats.comma-separator is missing! Using default #,###.00 instead.");
        }
        try {
            this.DATE_FORMAT = new SimpleDateFormat(dateFormat, Locale.getDefault());
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            toolStats.logger.error("Invalid format or missing format", (Throwable)exception);
            toolStats.logger.warn("date-format is NOT a valid format! Using default American English format.");
            this.DATE_FORMAT = new SimpleDateFormat("M/dd/yyyy", Locale.ENGLISH);
        }
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        formatSymbols.setDecimalSeparator(decimalSeparator.charAt(0));
        formatSymbols.setGroupingSeparator(commaSeparator.charAt(0));
        try {
            this.COMMA_FORMAT = new DecimalFormat(commaFormat, formatSymbols);
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            toolStats.logger.error("Invalid comma or missing format", (Throwable)exception);
            toolStats.logger.warn("number-formats.comma-format is NOT a valid format! Using default #,### instead.");
            this.COMMA_FORMAT = new DecimalFormat("#,###", formatSymbols);
        }
        try {
            this.DECIMAL_FORMAT = new DecimalFormat(decimalFormat, formatSymbols);
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            toolStats.logger.error("Invalid decimal or missing format", (Throwable)exception);
            toolStats.logger.warn("number-formats.decimal-format is NOT a valid format! Using default #,###.00 instead.");
            this.DECIMAL_FORMAT = new DecimalFormat("#,###.00", formatSymbols);
        }
    }

    public String formatInt(int number) {
        String finalNumber = this.COMMA_FORMAT.format(number);
        finalNumber = finalNumber.replaceAll("[\\x{202f}\\x{00A0}]", " ");
        return finalNumber;
    }

    public String formatDouble(double number) {
        String finalNumber = this.DECIMAL_FORMAT.format(number);
        finalNumber = finalNumber.replaceAll("[\\x{202f}\\x{00A0}]", " ");
        return finalNumber;
    }

    public String formatDate(Date date) {
        return this.DATE_FORMAT.format(date);
    }

    public Map<String, String> formatTime(Long time) {
        long seconds;
        long minutes;
        long hours;
        long days;
        long months;
        int SECONDS_PER_MINUTE = 60;
        int MINUTES_PER_HOUR = 60;
        int HOURS_PER_DAY = 24;
        int DAYS_PER_MONTH = 30;
        int DAYS_PER_YEAR = 365;
        long totalSeconds = time / 1000L;
        HashMap<String, String> timeUnits = new HashMap<String, String>();
        long years = totalSeconds / 31536000L;
        if (years > 0L) {
            timeUnits.put("years", Long.toString(years));
        }
        if ((months = (totalSeconds %= 31536000L) / 2592000L) > 0L) {
            timeUnits.put("months", Long.toString(months));
        }
        if ((days = (totalSeconds %= 2592000L) / 86400L) > 0L) {
            timeUnits.put("days", Long.toString(days));
        }
        if ((hours = (totalSeconds %= 86400L) / 3600L) > 0L) {
            timeUnits.put("hours", Long.toString(hours));
        }
        if ((minutes = (totalSeconds %= 3600L) / 60L) > 0L) {
            timeUnits.put("minutes", Long.toString(minutes));
        }
        if ((seconds = (totalSeconds %= 60L)) > 0L || timeUnits.isEmpty()) {
            timeUnits.put("seconds", Long.toString(seconds));
        }
        return timeUnits;
    }

    public Date normalizeTime(Long time) {
        Instant instant = Instant.ofEpochMilli(time);
        ZoneId zone = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zone).toLocalDate();
        ZonedDateTime midnight = localDate.atStartOfDay(zone);
        return Date.from(midnight.toInstant());
    }
}

