/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.config;

import dev.tarna.moretweaks.MoreTweaks;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001bJ\u0016\u0010 \u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Ldev/tarna/moretweaks/api/config/ConfigManager;", "", "plugin", "Ldev/tarna/moretweaks/MoreTweaks;", "<init>", "(Ldev/tarna/moretweaks/MoreTweaks;)V", "getPlugin", "()Ldev/tarna/moretweaks/MoreTweaks;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "setConfig", "(Lorg/bukkit/configuration/file/FileConfiguration;)V", "loadConfigFile", "", "matchConfig", "reload", "isTweakEnabled", "", "tweak", "", "setTweakEnabled", "enabled", "isRecipeEnabled", "recipe", "setRecipeEnabled", "MoreTweaks"})
public final class ConfigManager {
    @NotNull
    private final MoreTweaks plugin;
    public File file;
    public FileConfiguration config;

    public ConfigManager(@NotNull MoreTweaks plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.loadConfigFile();
    }

    @NotNull
    public final MoreTweaks getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final File getFile() {
        File file = this.file;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException("file");
        return null;
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.file = file;
    }

    @NotNull
    public final FileConfiguration getConfig() {
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration != null) {
            return fileConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    public final void setConfig(@NotNull FileConfiguration fileConfiguration) {
        Intrinsics.checkNotNullParameter(fileConfiguration, "<set-?>");
        this.config = fileConfiguration;
    }

    private final void loadConfigFile() {
        File file = this.plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue(file, "getDataFolder(...)");
        this.setFile(FilesKt.resolve(file, "config.yml"));
        if (!this.getFile().exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.setConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.getFile()));
        this.matchConfig();
    }

    private final void matchConfig() {
        try {
            boolean hasUpdated = false;
            InputStream inputStream = this.plugin.getResource(this.getFile().getName());
            if (inputStream == null) {
                throw new IllegalStateException("Failed to load config file".toString());
            }
            InputStream stream = inputStream;
            InputStreamReader inputStream2 = new InputStreamReader(stream);
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)inputStream2);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration defaultConfig = yamlConfiguration;
            ConfigurationSection configurationSection = defaultConfig.getConfigurationSection("");
            Intrinsics.checkNotNull(configurationSection);
            for (String key : configurationSection.getKeys(true)) {
                if (this.getConfig().contains(key)) continue;
                this.getConfig().set(key, defaultConfig.get(key));
                hasUpdated = true;
            }
            ConfigurationSection configurationSection2 = this.getConfig().getConfigurationSection("");
            Intrinsics.checkNotNull(configurationSection2);
            for (String key : configurationSection2.getKeys(true)) {
                if (defaultConfig.contains(key)) continue;
                this.getConfig().set(key, null);
                hasUpdated = true;
            }
            if (hasUpdated) {
                this.getConfig().save(this.getFile());
                this.plugin.getLogger().info("Updated config file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void reload() {
        this.plugin.reloadConfig();
        this.loadConfigFile();
    }

    public final boolean isTweakEnabled(@NotNull String tweak) {
        Intrinsics.checkNotNullParameter(tweak, "tweak");
        return this.getConfig().getBoolean("tweaks." + tweak + ".enabled");
    }

    public final void setTweakEnabled(@NotNull String tweak, boolean enabled) {
        Intrinsics.checkNotNullParameter(tweak, "tweak");
        this.getConfig().set("tweaks." + tweak + ".enabled", (Object)enabled);
        this.getConfig().save(this.getFile());
    }

    public final boolean isRecipeEnabled(@NotNull String recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        return this.getConfig().getBoolean("recipes." + recipe + ".enabled");
    }

    public final void setRecipeEnabled(@NotNull String recipe, boolean enabled) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        this.getConfig().set("recipes." + recipe + ".enabled", (Object)enabled);
        this.getConfig().save(this.getFile());
    }
}

