/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.config;

import dev.tarna.moretweaks.MoreTweaks;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\rR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/tarna/moretweaks/api/config/ConfigUtils;", "", "<init>", "()V", "plugin", "Ldev/tarna/moretweaks/MoreTweaks;", "kotlin.jvm.PlatformType", "Ldev/tarna/moretweaks/MoreTweaks;", "createConfig", "Lorg/bukkit/configuration/file/FileConfiguration;", "name", "", "getFile", "Ljava/io/File;", "getConfig", "file", "MoreTweaks"})
public final class ConfigUtils {
    @NotNull
    public static final ConfigUtils INSTANCE = new ConfigUtils();
    private static final MoreTweaks plugin = MoreTweaks.Companion.getPlugin();

    private ConfigUtils() {
    }

    @Nullable
    public final FileConfiguration createConfig(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        try {
            File file = plugin.getDataFolder();
            Intrinsics.checkNotNullExpressionValue(file, "getDataFolder(...)");
            File file2 = FilesKt.resolve(file, name2 + ".yml");
            if (!file2.exists()) {
                plugin.saveResource(name2 + ".yml", false);
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration config = yamlConfiguration;
            config.save(file2);
            return (FileConfiguration)config;
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to load " + name2 + ".yml");
            e.printStackTrace();
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return null;
        }
    }

    @NotNull
    public final File getFile(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        File file = plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue(file, "getDataFolder(...)");
        return FilesKt.resolve(file, name2 + ".yml");
    }

    @NotNull
    public final FileConfiguration getConfig(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        File file = this.getFile(name2);
        if (!file.exists()) {
            plugin.saveResource(name2 + ".yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return (FileConfiguration)yamlConfiguration;
    }

    @NotNull
    public final FileConfiguration getConfig(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return (FileConfiguration)yamlConfiguration;
    }
}

