/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.config.options.impl;

import dev.tarna.moretweaks.api.config.options.ConfigOption;
import dev.tarna.moretweaks.api.utils.DurationUtilsKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0010"}, d2={"Ldev/tarna/moretweaks/api/config/options/impl/DurationOption;", "Ldev/tarna/moretweaks/api/config/options/ConfigOption;", "Ljava/time/Duration;", "path", "", "default", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/time/Duration;)V", "getPath", "()Ljava/lang/String;", "getDefault", "get", "set", "", "value", "MoreTweaks"})
public final class DurationOption
extends ConfigOption<Duration> {
    @NotNull
    private final String path;
    @NotNull
    private final String default;

    public DurationOption(@NotNull String path, @NotNull String string) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(string, "default");
        this.path = path;
        this.default = string;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getDefault() {
        return this.default;
    }

    public DurationOption(@NotNull String path, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(duration, "default");
        this(path, DurationUtilsKt.toDurationString(duration));
    }

    @Override
    @NotNull
    public Duration get() {
        String string = this.getConfig().getString(this.path, this.default);
        if (string == null) {
            string = this.default;
        }
        return DurationUtilsKt.parseDuration(string);
    }

    @Override
    public void set(@NotNull Duration value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.getConfig().set(this.path, (Object)DurationUtilsKt.toDurationString(value));
        this.getConfig().save(this.getFile());
    }
}

