/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.lang;

import dev.tarna.moretweaks.MoreTweaks;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Ldev/tarna/moretweaks/api/lang/Language;", "", "plugin", "Ldev/tarna/moretweaks/MoreTweaks;", "lang", "", "<init>", "(Ldev/tarna/moretweaks/MoreTweaks;Ljava/lang/String;)V", "getPlugin", "()Ldev/tarna/moretweaks/MoreTweaks;", "getLang", "()Ljava/lang/String;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "messages", "Lorg/bukkit/configuration/file/FileConfiguration;", "getMessages", "()Lorg/bukkit/configuration/file/FileConfiguration;", "setMessages", "(Lorg/bukkit/configuration/file/FileConfiguration;)V", "matchConfig", "", "MoreTweaks"})
public final class Language {
    @NotNull
    private final MoreTweaks plugin;
    @NotNull
    private final String lang;
    @NotNull
    private final File file;
    @NotNull
    private FileConfiguration messages;

    public Language(@NotNull MoreTweaks plugin, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(lang, "lang");
        this.plugin = plugin;
        this.lang = lang;
        File file = this.plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue(file, "getDataFolder(...)");
        this.file = FilesKt.resolve(file, "lang/" + this.lang + ".yml");
        if (!this.file.exists()) {
            this.plugin.saveResource("lang/" + this.lang + ".yml", false);
        }
        this.messages = (FileConfiguration)YamlConfiguration.loadConfiguration((File)this.file);
        this.matchConfig();
    }

    @NotNull
    public final MoreTweaks getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final FileConfiguration getMessages() {
        return this.messages;
    }

    public final void setMessages(@NotNull FileConfiguration fileConfiguration) {
        Intrinsics.checkNotNullParameter(fileConfiguration, "<set-?>");
        this.messages = fileConfiguration;
    }

    private final void matchConfig() {
        try {
            boolean hasUpdated = false;
            InputStream inputStream = this.plugin.getResource("lang/" + this.lang + ".yml");
            if (inputStream == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            InputStream stream = inputStream;
            InputStreamReader is = new InputStreamReader(stream);
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)is);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration defConfig = yamlConfiguration;
            ConfigurationSection configurationSection = defConfig.getConfigurationSection("");
            Intrinsics.checkNotNull(configurationSection);
            for (String key : configurationSection.getKeys(true)) {
                if (this.messages.contains(key)) continue;
                this.messages.set(key, defConfig.get(key));
                hasUpdated = true;
            }
            ConfigurationSection configurationSection2 = this.messages.getConfigurationSection("");
            Intrinsics.checkNotNull(configurationSection2);
            for (String key : configurationSection2.getKeys(true)) {
                if (defConfig.contains(key)) continue;
                this.messages.set(key, null);
                hasUpdated = true;
            }
            if (hasUpdated) {
                this.messages.save(this.file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

