/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.lang;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.lang.Language;
import dev.tarna.moretweaks.api.utils.StringUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ'\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\n2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\nR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Ldev/tarna/moretweaks/api/lang/Translatable;", "", "<init>", "()V", "plugin", "Ldev/tarna/moretweaks/MoreTweaks;", "kotlin.jvm.PlatformType", "Ldev/tarna/moretweaks/MoreTweaks;", "languageList", "", "", "getLanguageList", "()Ljava/util/List;", "languages", "", "Ldev/tarna/moretweaks/api/lang/Language;", "currentLanguage", "getCurrentLanguage", "()Ldev/tarna/moretweaks/api/lang/Language;", "setCurrentLanguage", "(Ldev/tarna/moretweaks/api/lang/Language;)V", "init", "", "lang", "getString", "key", "get", "Lnet/kyori/adventure/text/Component;", "resolvers", "", "Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "(Ljava/lang/String;[Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;)Lnet/kyori/adventure/text/Component;", "getLanguage", "MoreTweaks"})
@SourceDebugExtension(value={"SMAP\nTranslatable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translatable.kt\ndev/tarna/moretweaks/api/lang/Translatable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1863#2,2:48\n230#2,2:50\n*S KotlinDebug\n*F\n+ 1 Translatable.kt\ndev/tarna/moretweaks/api/lang/Translatable\n*L\n26#1:48,2\n45#1:50,2\n*E\n"})
public final class Translatable {
    @NotNull
    public static final Translatable INSTANCE = new Translatable();
    private static final MoreTweaks plugin = MoreTweaks.Companion.getPlugin();
    @NotNull
    private static final List<String> languageList;
    @NotNull
    private static final List<Language> languages;
    public static Language currentLanguage;

    private Translatable() {
    }

    @NotNull
    public final List<String> getLanguageList() {
        return languageList;
    }

    @NotNull
    public final Language getCurrentLanguage() {
        Language language = currentLanguage;
        if (language != null) {
            return language;
        }
        Intrinsics.throwUninitializedPropertyAccessException("currentLanguage");
        return null;
    }

    public final void setCurrentLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter(language, "<set-?>");
        currentLanguage = language;
    }

    public final void init(@NotNull String lang) {
        Intrinsics.checkNotNullParameter(lang, "lang");
        String[] stringArray = new String[]{"en_us", "es_mx"};
        List<String> langList = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = langList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            MoreTweaks moreTweaks = plugin;
            Intrinsics.checkNotNullExpressionValue((Object)moreTweaks, "plugin");
            languages.add(new Language(moreTweaks, it));
            plugin.getLogger().info("Loaded language " + it);
        }
        this.setCurrentLanguage(this.getLanguage(lang));
        plugin.getLogger().info("Language set to " + this.getCurrentLanguage().getLang());
    }

    @NotNull
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String string = this.getCurrentLanguage().getMessages().getString(key);
        if (string == null && (string = this.getLanguage("en_us").getMessages().getString(key)) == null) {
            string = key;
        }
        return string;
    }

    @NotNull
    public final Component get(@NotNull String key, TagResolver ... resolvers) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(resolvers, "resolvers");
        String msg = this.getString(key);
        Component component = StringUtilsKt.getMm().deserialize(msg, Arrays.copyOf(resolvers, resolvers.length));
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        return component;
    }

    @NotNull
    public final Language getLanguage(@NotNull String lang) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter(lang, "lang");
            Iterable $this$first$iv = languages;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Language it = (Language)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getLang(), lang)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Language)element$iv2;
    }

    static {
        String[] stringArray = new String[]{"en_us", "es_mx"};
        languageList = CollectionsKt.listOf(stringArray);
        languages = new ArrayList();
    }
}

