/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.recipes;

import dev.tarna.moretweaks.api.lang.Translatable;
import dev.tarna.moretweaks.api.utils.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eH&J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0005R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Ldev/tarna/moretweaks/api/recipes/CustomRecipe;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "name", "getName", "setName", "description", "getDescription", "setDescription", "recipes", "", "Lorg/bukkit/inventory/Recipe;", "getRecipes", "()Ljava/util/List;", "setRecipes", "(Ljava/util/List;)V", "key", "Lorg/bukkit/NamespacedKey;", "getKey", "()Lorg/bukkit/NamespacedKey;", "key$delegate", "Lkotlin/Lazy;", "reload", "", "registerRecipes", "", "register", "unregister", "isRegistered", "", "MoreTweaks"})
public abstract class CustomRecipe {
    @NotNull
    private final String path;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @NotNull
    private List<Recipe> recipes;
    @NotNull
    private final Lazy key$delegate;

    public CustomRecipe(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.path = path;
        this.recipes = new ArrayList();
        String langKey = StringsKt.replace$default(this.path, "-", "_", false, 4, null);
        this.name = Translatable.INSTANCE.getString("recipe." + langKey + ".name");
        this.description = Translatable.INSTANCE.getString("recipe." + langKey + ".description");
        this.key$delegate = LazyKt.lazy(() -> CustomRecipe.key_delegate$lambda$0(this));
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.description = string;
    }

    @NotNull
    public final List<Recipe> getRecipes() {
        return this.recipes;
    }

    public final void setRecipes(@NotNull List<Recipe> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.recipes = list;
    }

    @NotNull
    public final NamespacedKey getKey() {
        Lazy lazy = this.key$delegate;
        return (NamespacedKey)lazy.getValue();
    }

    public void reload() {
    }

    @NotNull
    public abstract List<Recipe> registerRecipes();

    public final void register() {
        for (Recipe recipe : this.registerRecipes()) {
            Bukkit.addRecipe((Recipe)recipe, (boolean)true);
            this.recipes.add(recipe);
        }
    }

    public final void unregister() {
        for (Recipe recipe : this.recipes) {
            Intrinsics.checkNotNull(recipe, "null cannot be cast to non-null type org.bukkit.Keyed");
            Bukkit.removeRecipe((NamespacedKey)((Keyed)recipe).getKey(), (boolean)true);
        }
        this.recipes.clear();
    }

    public final boolean isRegistered() {
        return !((Collection)this.recipes).isEmpty();
    }

    private static final NamespacedKey key_delegate$lambda$0(CustomRecipe this$0) {
        return Key.INSTANCE.get(this$0.path);
    }
}

