/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.recipes;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.config.ConfigManager;
import dev.tarna.moretweaks.api.recipes.CustomRecipe;
import dev.tarna.moretweaks.api.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0016\u001a\u00020\u00172\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0018\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00172\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0018\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eJ\u0006\u0010!\u001a\u00020\u0017J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u0006\u0010%\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006&"}, d2={"Ldev/tarna/moretweaks/api/recipes/RecipeManager;", "", "plugin", "Ldev/tarna/moretweaks/MoreTweaks;", "<init>", "(Ldev/tarna/moretweaks/MoreTweaks;)V", "getPlugin", "()Ldev/tarna/moretweaks/MoreTweaks;", "configManager", "Ldev/tarna/moretweaks/api/config/ConfigManager;", "getConfigManager", "()Ldev/tarna/moretweaks/api/config/ConfigManager;", "recipes", "", "Ldev/tarna/moretweaks/api/recipes/CustomRecipe;", "getRecipes", "()Ljava/util/List;", "enabledRecipes", "getEnabledRecipes", "disabledRecipes", "", "getDisabledRecipes", "register", "", "", "([Ldev/tarna/moretweaks/api/recipes/CustomRecipe;)V", "unregister", "getRecipe", "id", "", "isRecipeEnabled", "", "recipe", "load", "enable", "disable", "toggle", "reloadAll", "MoreTweaks"})
@SourceDebugExtension(value={"SMAP\nRecipeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeManager.kt\ndev/tarna/moretweaks/api/recipes/RecipeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ReflectionUtils.kt\ndev/tarna/moretweaks/api/utils/ReflectionUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n8#3,2:77\n1557#4:79\n1628#4,3:80\n*S KotlinDebug\n*F\n+ 1 RecipeManager.kt\ndev/tarna/moretweaks/api/recipes/RecipeManager\n*L\n31#1:77,2\n31#1:79\n31#1:80,3\n*E\n"})
public final class RecipeManager {
    @NotNull
    private final MoreTweaks plugin;
    @NotNull
    private final ConfigManager configManager;
    @NotNull
    private final List<CustomRecipe> recipes;
    @NotNull
    private final List<CustomRecipe> enabledRecipes;

    public RecipeManager(@NotNull MoreTweaks plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.configManager = this.plugin.getConfigManager();
        this.recipes = new ArrayList();
        this.enabledRecipes = new ArrayList();
    }

    @NotNull
    public final MoreTweaks getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final List<CustomRecipe> getRecipes() {
        return this.recipes;
    }

    @NotNull
    public final List<CustomRecipe> getEnabledRecipes() {
        return this.enabledRecipes;
    }

    @NotNull
    public final List<CustomRecipe> getDisabledRecipes() {
        return CollectionsKt.minus((Iterable)this.recipes, CollectionsKt.toSet((Iterable)this.enabledRecipes));
    }

    public final void register(CustomRecipe ... recipes) {
        Intrinsics.checkNotNullParameter(recipes, "recipes");
        CollectionsKt.addAll((Collection)this.recipes, recipes);
    }

    public final void unregister(CustomRecipe ... recipes) {
        Intrinsics.checkNotNullParameter(recipes, "recipes");
        this.recipes.removeAll((Collection)ArraysKt.toSet(recipes));
    }

    @Nullable
    public final CustomRecipe getRecipe(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(id, "id");
            Iterable iterable = this.recipes;
            for (Object t : iterable) {
                CustomRecipe it = (CustomRecipe)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getPath(), id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isRecipeEnabled(@NotNull CustomRecipe recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        return this.enabledRecipes.contains(recipe);
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        void $this$mapTo$iv$iv$iv;
        ReflectionUtils reflectionUtils = ReflectionUtils.INSTANCE;
        String packageName$iv = "dev.tarna.moretweaks.recipes";
        boolean $i$f$getClassesOfType = false;
        Reflections reflections$iv = new Reflections(packageName$iv, new Scanner[0]);
        Set<Class<CustomRecipe>> set = reflections$iv.getSubTypesOf(CustomRecipe.class);
        Intrinsics.checkNotNullExpressionValue(set, "getSubTypesOf(...)");
        Iterable $this$map$iv$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            Class clazz = (Class)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add(it$iv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        Set<CustomRecipe> recipes = CollectionsKt.toSet((List)destination$iv$iv$iv);
        for (CustomRecipe recipe : recipes) {
            CustomRecipe[] customRecipeArray = new CustomRecipe[]{recipe};
            this.register(customRecipeArray);
            if (!this.configManager.isRecipeEnabled(recipe.getPath())) continue;
            this.enable(recipe);
        }
        this.plugin.getLogger().info("Loaded " + recipes.size() + " recipes");
    }

    public final void enable(@NotNull CustomRecipe recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        if (this.enabledRecipes.contains(recipe)) {
            return;
        }
        this.enabledRecipes.add(recipe);
        recipe.reload();
        recipe.register();
        this.configManager.setRecipeEnabled(recipe.getPath(), true);
        this.plugin.getLogger().info("Enabled recipe: " + recipe.getName());
    }

    public final void disable(@NotNull CustomRecipe recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        if (!this.enabledRecipes.contains(recipe)) {
            return;
        }
        this.enabledRecipes.remove(recipe);
        recipe.unregister();
        this.configManager.setRecipeEnabled(recipe.getPath(), false);
        this.plugin.getLogger().info("Disabled recipe: " + recipe.getName());
    }

    public final void toggle(@NotNull CustomRecipe recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        if (this.isRecipeEnabled(recipe)) {
            this.disable(recipe);
        } else {
            this.enable(recipe);
        }
    }

    public final void reloadAll() {
        for (CustomRecipe recipe : this.recipes) {
            if (!this.isRecipeEnabled(recipe)) continue;
            recipe.reload();
            recipe.unregister();
            recipe.register();
        }
    }
}

