/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.config.ConfigManager;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0016\u001a\u00020\u00172\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0018\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00172\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0018\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0006\u0010$\u001a\u00020\u0017J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u0006\u0010(\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006)"}, d2={"Ldev/tarna/moretweaks/api/tweaks/TweakManager;", "", "plugin", "Ldev/tarna/moretweaks/MoreTweaks;", "<init>", "(Ldev/tarna/moretweaks/MoreTweaks;)V", "getPlugin", "()Ldev/tarna/moretweaks/MoreTweaks;", "configManager", "Ldev/tarna/moretweaks/api/config/ConfigManager;", "getConfigManager", "()Ldev/tarna/moretweaks/api/config/ConfigManager;", "tweaks", "", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "getTweaks", "()Ljava/util/List;", "enabledTweaks", "getEnabledTweaks", "disabledTweaks", "", "getDisabledTweaks", "register", "", "", "([Ldev/tarna/moretweaks/api/tweaks/Tweak;)V", "unregister", "getTweak", "id", "", "isTweakEnabled", "", "tweak", "getRequiredCustomListeners", "", "Lorg/bukkit/event/Listener;", "load", "enable", "disable", "toggle", "reloadAll", "MoreTweaks"})
@SourceDebugExtension(value={"SMAP\nTweakManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TweakManager.kt\ndev/tarna/moretweaks/api/tweaks/TweakManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ReflectionUtils.kt\ndev/tarna/moretweaks/api/utils/ReflectionUtils\n*L\n1#1,80:1\n1#2:81\n1368#3:82\n1454#3,5:83\n1557#3:88\n1628#3,3:89\n1557#3:94\n1628#3,3:95\n1863#3,2:98\n8#4,2:92\n*S KotlinDebug\n*F\n+ 1 TweakManager.kt\ndev/tarna/moretweaks/api/tweaks/TweakManager\n*L\n34#1:82\n34#1:83,5\n35#1:88\n35#1:89,3\n40#1:94\n40#1:95,3\n78#1:98,2\n40#1:92,2\n*E\n"})
public final class TweakManager {
    @NotNull
    private final MoreTweaks plugin;
    @NotNull
    private final ConfigManager configManager;
    @NotNull
    private final List<Tweak> tweaks;
    @NotNull
    private final List<Tweak> enabledTweaks;

    public TweakManager(@NotNull MoreTweaks plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.configManager = this.plugin.getConfigManager();
        this.tweaks = new ArrayList();
        this.enabledTweaks = new ArrayList();
    }

    @NotNull
    public final MoreTweaks getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final List<Tweak> getTweaks() {
        return this.tweaks;
    }

    @NotNull
    public final List<Tweak> getEnabledTweaks() {
        return this.enabledTweaks;
    }

    @NotNull
    public final List<Tweak> getDisabledTweaks() {
        return CollectionsKt.minus((Iterable)this.tweaks, CollectionsKt.toSet((Iterable)this.enabledTweaks));
    }

    public final void register(Tweak ... tweaks) {
        Intrinsics.checkNotNullParameter(tweaks, "tweaks");
        CollectionsKt.addAll((Collection)this.tweaks, tweaks);
    }

    public final void unregister(Tweak ... tweaks) {
        Intrinsics.checkNotNullParameter(tweaks, "tweaks");
        this.tweaks.removeAll((Collection)ArraysKt.toSet(tweaks));
    }

    @Nullable
    public final Tweak getTweak(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(id, "id");
            Iterable iterable = this.tweaks;
            for (Object t : iterable) {
                Tweak it = (Tweak)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isTweakEnabled(@NotNull Tweak tweak) {
        Intrinsics.checkNotNullParameter(tweak, "tweak");
        return this.enabledTweaks.contains(tweak);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Listener> getRequiredCustomListeners() {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Tweak it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.tweaks;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Tweak)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.requiredCustomListeners();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Class)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Listener)((Class)((Object)it)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        void $this$mapTo$iv$iv$iv;
        ReflectionUtils reflectionUtils = ReflectionUtils.INSTANCE;
        String packageName$iv = "dev.tarna.moretweaks.tweaks";
        boolean $i$f$getClassesOfType = false;
        Reflections reflections$iv = new Reflections(packageName$iv, new Scanner[0]);
        Set<Class<Tweak>> set = reflections$iv.getSubTypesOf(Tweak.class);
        Intrinsics.checkNotNullExpressionValue(set, "getSubTypesOf(...)");
        Iterable $this$map$iv$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            Class clazz = (Class)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add(it$iv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        Set<Tweak> classes = CollectionsKt.toSet((List)destination$iv$iv$iv);
        for (Tweak tweak : classes) {
            Tweak[] tweakArray = new Tweak[]{tweak};
            this.register(tweakArray);
            if (!this.configManager.isTweakEnabled(tweak.getId())) continue;
            this.enable(tweak);
        }
        this.plugin.getLogger().info("Loaded " + this.tweaks.size() + " tweaks");
    }

    public final void enable(@NotNull Tweak tweak) {
        Intrinsics.checkNotNullParameter(tweak, "tweak");
        if (this.enabledTweaks.contains(tweak)) {
            return;
        }
        this.enabledTweaks.add(tweak);
        tweak.reload();
        tweak.enable();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)tweak, (Plugin)this.plugin);
        this.configManager.setTweakEnabled(tweak.getId(), true);
        this.plugin.getLogger().info("Enabled tweak: " + tweak.getPrettyName());
    }

    public final void disable(@NotNull Tweak tweak) {
        Intrinsics.checkNotNullParameter(tweak, "tweak");
        if (!this.enabledTweaks.contains(tweak)) {
            return;
        }
        this.enabledTweaks.remove(tweak);
        tweak.disable();
        HandlerList.unregisterAll((Listener)tweak);
        this.configManager.setTweakEnabled(tweak.getId(), false);
        this.plugin.getLogger().info("Disabled tweak: " + tweak.getPrettyName());
    }

    public final void toggle(@NotNull Tweak tweak) {
        Intrinsics.checkNotNullParameter(tweak, "tweak");
        if (this.isTweakEnabled(tweak)) {
            this.disable(tweak);
        } else {
            this.enable(tweak);
        }
    }

    public final void reloadAll() {
        Iterable $this$forEach$iv = this.enabledTweaks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tweak it = (Tweak)element$iv;
            boolean bl = false;
            it.reload();
        }
    }
}

