/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.utils;

import dev.tarna.moretweaks.api.utils.MaterialListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a1\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0013"}, d2={"isSapling", "", "Lorg/bukkit/block/Block;", "(Lorg/bukkit/block/Block;)Z", "isLog", "isPlank", "isWool", "isFarmLand", "getNearbyBlocks", "", "Lorg/bukkit/Location;", "radius", "", "types", "", "Lorg/bukkit/Material;", "(Lorg/bukkit/Location;I[Lorg/bukkit/Material;)Ljava/util/List;", "getNearbyContainers", "Lorg/bukkit/block/Container;", "MoreTweaks"})
@SourceDebugExtension(value={"SMAP\nBlockUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockUtils.kt\ndev/tarna/moretweaks/api/utils/BlockUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1557#2:53\n1628#2,3:54\n808#2,11:57\n*S KotlinDebug\n*F\n+ 1 BlockUtils.kt\ndev/tarna/moretweaks/api/utils/BlockUtilsKt\n*L\n50#1:53\n50#1:54,3\n51#1:57,11\n*E\n"})
public final class BlockUtilsKt {
    public static final boolean isSapling(@NotNull Block $this$isSapling) {
        Intrinsics.checkNotNullParameter($this$isSapling, "<this>");
        return MaterialListKt.getAllSaplings().contains($this$isSapling.getType());
    }

    public static final boolean isLog(@NotNull Block $this$isLog) {
        Intrinsics.checkNotNullParameter($this$isLog, "<this>");
        return MaterialListKt.getAllLogs().contains($this$isLog.getType());
    }

    public static final boolean isPlank(@NotNull Block $this$isPlank) {
        Intrinsics.checkNotNullParameter($this$isPlank, "<this>");
        return MaterialListKt.getAllPlanks().contains($this$isPlank.getType());
    }

    public static final boolean isWool(@NotNull Block $this$isWool) {
        Intrinsics.checkNotNullParameter($this$isWool, "<this>");
        return MaterialListKt.getAllWool().contains($this$isWool.getType());
    }

    public static final boolean isFarmLand(@NotNull Block $this$isFarmLand) {
        Intrinsics.checkNotNullParameter($this$isFarmLand, "<this>");
        return MaterialListKt.getAllFarmLandBlocks().contains($this$isFarmLand.getType());
    }

    @NotNull
    public static final List<Block> getNearbyBlocks(@NotNull Location $this$getNearbyBlocks, int radius) {
        Intrinsics.checkNotNullParameter($this$getNearbyBlocks, "<this>");
        List blocks = new ArrayList();
        int x = -radius;
        if (x <= radius) {
            while (true) {
                int y;
                if ((y = -radius) <= radius) {
                    while (true) {
                        int z;
                        if ((z = -radius) <= radius) {
                            while (true) {
                                Block block = $this$getNearbyBlocks.clone().add((double)x, (double)y, (double)z).getBlock();
                                Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
                                blocks.add(block);
                                if (z == radius) break;
                                ++z;
                            }
                        }
                        if (y == radius) break;
                        ++y;
                    }
                }
                if (x == radius) break;
                ++x;
            }
        }
        return blocks;
    }

    @NotNull
    public static final List<Block> getNearbyBlocks(@NotNull Location $this$getNearbyBlocks, int radius, Material ... types) {
        Intrinsics.checkNotNullParameter($this$getNearbyBlocks, "<this>");
        Intrinsics.checkNotNullParameter(types, "types");
        List blocks = new ArrayList();
        int x = -radius;
        if (x <= radius) {
            while (true) {
                int y;
                if ((y = -radius) <= radius) {
                    while (true) {
                        int z;
                        if ((z = -radius) <= radius) {
                            while (true) {
                                Block block;
                                Intrinsics.checkNotNullExpressionValue($this$getNearbyBlocks.clone().add((double)x, (double)y, (double)z).getBlock(), "getBlock(...)");
                                if (ArraysKt.contains(types, block.getType())) {
                                    blocks.add(block);
                                }
                                if (z == radius) break;
                                ++z;
                            }
                        }
                        if (y == radius) break;
                        ++y;
                    }
                }
                if (x == radius) break;
                ++x;
            }
        }
        return blocks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Container> getNearbyContainers(@NotNull Location $this$getNearbyContainers, int radius) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getNearbyContainers, "<this>");
        Iterable $this$map$iv = BlockUtilsKt.getNearbyBlocks($this$getNearbyContainers, radius);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Block block = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getState());
        }
        List blocks = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = blocks;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Container)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

