/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.utils;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u00a8\u0006\u0006"}, d2={"parseDuration", "Ljava/time/Duration;", "", "toDurationString", "toTicks", "", "MoreTweaks"})
public final class DurationUtilsKt {
    @NotNull
    public static final Duration parseDuration(@NotNull String $this$parseDuration) {
        Duration duration;
        Intrinsics.checkNotNullParameter($this$parseDuration, "<this>");
        String duration2 = $this$parseDuration;
        String string = duration2.substring(0, duration2.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        long time = Long.parseLong(string);
        char unit = duration2.charAt(duration2.length() - 1);
        switch (unit) {
            case 's': {
                Duration duration3 = Duration.ofSeconds(time);
                duration = duration3;
                Intrinsics.checkNotNullExpressionValue(duration3, "ofSeconds(...)");
                break;
            }
            case 'm': {
                Duration duration4 = Duration.ofMinutes(time);
                duration = duration4;
                Intrinsics.checkNotNullExpressionValue(duration4, "ofMinutes(...)");
                break;
            }
            case 'h': {
                Duration duration5 = Duration.ofHours(time);
                duration = duration5;
                Intrinsics.checkNotNullExpressionValue(duration5, "ofHours(...)");
                break;
            }
            case 'd': {
                Duration duration6 = Duration.ofDays(time);
                duration = duration6;
                Intrinsics.checkNotNullExpressionValue(duration6, "ofDays(...)");
                break;
            }
            case 't': {
                Duration duration7 = Duration.ofMillis(time * (long)50);
                duration = duration7;
                Intrinsics.checkNotNullExpressionValue(duration7, "ofMillis(...)");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid duration unit: " + unit);
            }
        }
        return duration;
    }

    @NotNull
    public static final String toDurationString(@NotNull Duration $this$toDurationString) {
        Intrinsics.checkNotNullParameter($this$toDurationString, "<this>");
        return $this$toDurationString.toDaysPart() > 0L ? $this$toDurationString.toDaysPart() + "d" : ($this$toDurationString.toHoursPart() > 0 ? $this$toDurationString.toHoursPart() + "h" : ($this$toDurationString.toMinutesPart() > 0 ? $this$toDurationString.toMinutesPart() + "m" : ($this$toDurationString.toSecondsPart() > 0 ? $this$toDurationString.toSecondsPart() + "s" : $this$toDurationString.toMillis() + "t")));
    }

    public static final long toTicks(@NotNull Duration $this$toTicks) {
        Intrinsics.checkNotNullParameter($this$toTicks, "<this>");
        return $this$toTicks.toMillis() / (long)50;
    }
}

