/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.api.utils;

import dev.tarna.moretweaks.api.utils.Key;
import dev.tarna.moretweaks.api.utils.MaterialListKt;
import dev.tarna.moretweaks.api.utils.StringUtilsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\b\u001a\u00020\u0002*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\b\u001a\u00020\u0002*\u00020\t2\u0006\u0010\n\u001a\u00020\f\u001a;\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\u000f2\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u000f0\u0015\u00a2\u0006\u0002\u0010\u0016\u001a1\u0010\u0017\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u000f0\u0015\u00a2\u0006\u0002\u0010\u0018\u001a*\u0010\u0019\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u000f0\u0015\u001a\u0012\u0010\u001a\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0012\u001a#\u0010\u001c\u001a\u00020\u000e*\u00020\u00022\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001e\"\u00020\u0012\u00a2\u0006\u0002\u0010\u001f\u001a$\u0010 \u001a\u00020\u000e*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\b\b\u0002\u0010%\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010&\u001a\u00020\u0001*\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010(\u00a8\u0006)"}, d2={"isSapling", "", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/bukkit/inventory/ItemStack;)Z", "isLog", "isPlank", "isWool", "isFarmLand", "toItemStack", "Lorg/bukkit/Material;", "amount", "", "", "setValue", "", "T", "", "key", "", "value", "type", "Lorg/bukkit/persistence/PersistentDataType;", "(Lorg/bukkit/inventory/ItemStack;Ljava/lang/String;Ljava/lang/Object;Lorg/bukkit/persistence/PersistentDataType;)V", "getValue", "(Lorg/bukkit/inventory/ItemStack;Ljava/lang/String;Lorg/bukkit/persistence/PersistentDataType;)Ljava/lang/Object;", "hasValue", "setName", "name", "setLore", "lore", "", "(Lorg/bukkit/inventory/ItemStack;[Ljava/lang/String;)V", "dropItemWithoutVelocity", "Lorg/bukkit/World;", "location", "Lorg/bukkit/Location;", "item", "gravity", "isCauldron", "Lorg/bukkit/block/Block;", "(Lorg/bukkit/block/Block;)Z", "MoreTweaks"})
public final class ItemUtilsKt {
    public static final boolean isSapling(@NotNull ItemStack $this$isSapling) {
        Intrinsics.checkNotNullParameter($this$isSapling, "<this>");
        return MaterialListKt.getAllSaplings().contains($this$isSapling.getType());
    }

    public static final boolean isLog(@NotNull ItemStack $this$isLog) {
        Intrinsics.checkNotNullParameter($this$isLog, "<this>");
        return MaterialListKt.getAllLogs().contains($this$isLog.getType());
    }

    public static final boolean isPlank(@NotNull ItemStack $this$isPlank) {
        Intrinsics.checkNotNullParameter($this$isPlank, "<this>");
        return MaterialListKt.getAllPlanks().contains($this$isPlank.getType());
    }

    public static final boolean isWool(@NotNull ItemStack $this$isWool) {
        Intrinsics.checkNotNullParameter($this$isWool, "<this>");
        return MaterialListKt.getAllWool().contains($this$isWool.getType());
    }

    public static final boolean isFarmLand(@NotNull ItemStack $this$isFarmLand) {
        Intrinsics.checkNotNullParameter($this$isFarmLand, "<this>");
        return MaterialListKt.getAllFarmLandBlocks().contains($this$isFarmLand.getType());
    }

    @NotNull
    public static final ItemStack toItemStack(@NotNull Material $this$toItemStack, int amount) {
        Intrinsics.checkNotNullParameter($this$toItemStack, "<this>");
        return new ItemStack($this$toItemStack, amount);
    }

    public static /* synthetic */ ItemStack toItemStack$default(Material material, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return ItemUtilsKt.toItemStack(material, n);
    }

    @NotNull
    public static final ItemStack toItemStack(@NotNull Material $this$toItemStack, @NotNull Number amount) {
        Intrinsics.checkNotNullParameter($this$toItemStack, "<this>");
        Intrinsics.checkNotNullParameter(amount, "amount");
        return ItemUtilsKt.toItemStack($this$toItemStack, amount.intValue());
    }

    public static final <T> void setValue(@NotNull ItemStack $this$setValue, @NotNull String key, @NotNull T value, @NotNull PersistentDataType<?, T> type) {
        Intrinsics.checkNotNullParameter($this$setValue, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(type, "type");
        ItemMeta meta = $this$setValue.getItemMeta();
        meta.getPersistentDataContainer().set(Key.INSTANCE.get(key), type, value);
        $this$setValue.setItemMeta(meta);
    }

    @Nullable
    public static final <T> T getValue(@NotNull ItemStack $this$getValue, @NotNull String key, @NotNull PersistentDataType<?, T> type) {
        Intrinsics.checkNotNullParameter($this$getValue, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(type, "type");
        return (T)$this$getValue.getItemMeta().getPersistentDataContainer().get(Key.INSTANCE.get(key), type);
    }

    public static final <T> boolean hasValue(@NotNull ItemStack $this$hasValue, @NotNull String key, @NotNull PersistentDataType<?, T> type) {
        Intrinsics.checkNotNullParameter($this$hasValue, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(type, "type");
        return $this$hasValue.getItemMeta().getPersistentDataContainer().has(Key.INSTANCE.get(key), type);
    }

    public static final void setName(@NotNull ItemStack $this$setName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$setName, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        ItemMeta meta = $this$setName.getItemMeta();
        meta.displayName(StringUtilsKt.not(name2));
        $this$setName.setItemMeta(meta);
    }

    public static final void setLore(@NotNull ItemStack $this$setLore, String ... lore2) {
        Intrinsics.checkNotNullParameter($this$setLore, "<this>");
        Intrinsics.checkNotNullParameter(lore2, "lore");
        ItemMeta meta = $this$setLore.getItemMeta();
        meta.lore(StringUtilsKt.not(ArraysKt.toList(lore2)));
        $this$setLore.setItemMeta(meta);
    }

    public static final void dropItemWithoutVelocity(@NotNull World $this$dropItemWithoutVelocity, @NotNull Location location, @NotNull ItemStack item2, boolean gravity) {
        Intrinsics.checkNotNullParameter($this$dropItemWithoutVelocity, "<this>");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(item2, "item");
        Item item3 = $this$dropItemWithoutVelocity.dropItemNaturally(location, item2);
        Intrinsics.checkNotNullExpressionValue(item3, "dropItemNaturally(...)");
        Item dropped = item3;
        dropped.setVelocity(new Vector(0, 0, 0));
        dropped.setGravity(gravity);
    }

    public static /* synthetic */ void dropItemWithoutVelocity$default(World world, Location location, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        ItemUtilsKt.dropItemWithoutVelocity(world, location, itemStack, bl);
    }

    public static final boolean isCauldron(@NotNull Block $this$isCauldron) {
        Intrinsics.checkNotNullParameter($this$isCauldron, "<this>");
        return $this$isCauldron.getType() == Material.CAULDRON || $this$isCauldron.getType() == Material.WATER_CAULDRON || $this$isCauldron.getType() == Material.LAVA_CAULDRON;
    }
}

