/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.commands.tweaks;

import dev.tarna.moretweaks.api.commands.CustomCommand;
import dev.tarna.moretweaks.api.commands.TweakCommand;
import dev.tarna.moretweaks.api.lang.Translatable;
import dev.tarna.moretweaks.api.utils.StringUtilsKt;
import dev.tarna.moretweaks.config.tweaks.RealTimeClockConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ldev/tarna/moretweaks/commands/tweaks/RealTimeClockCommand;", "Ldev/tarna/moretweaks/api/commands/CustomCommand;", "Ldev/tarna/moretweaks/api/commands/TweakCommand;", "command", "", "<init>", "(Ljava/lang/String;)V", "playerOnly", "", "getPlayerOnly", "()Z", "execute", "", "player", "Lorg/bukkit/entity/Player;", "args", "", "(Lorg/bukkit/entity/Player;[Ljava/lang/String;)V", "getPermission", "MoreTweaks"})
public final class RealTimeClockCommand
extends CustomCommand
implements TweakCommand {
    private final boolean playerOnly;

    public RealTimeClockCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter(command, "command");
        super(command);
        this.playerOnly = true;
    }

    @Override
    public boolean getPlayerOnly() {
        return this.playerOnly;
    }

    @Override
    public void execute(@NotNull Player player, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(args2, "args");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        long time = world2.getGameTime();
        int days = (int)(time / (long)20 / (long)60 / (long)60 / (long)24);
        int hours = (int)(time / (long)20 / (long)60 / (long)60) % 24;
        int minutes = (int)(time / (long)20 / (long)60) % 60;
        TagResolver[] tagResolverArray = new TagResolver[]{StringUtilsKt.placeholder("days", String.valueOf(days)), StringUtilsKt.placeholder("hours", String.valueOf(hours)), StringUtilsKt.placeholder("minutes", String.valueOf(minutes))};
        Component message = Translatable.INSTANCE.get("tweak.real_time_clock.message", tagResolverArray);
        player.sendMessage(message);
    }

    @NotNull
    public String getPermission() {
        return RealTimeClockConfig.INSTANCE.getPermission();
    }
}

