/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.recipes;

import dev.tarna.moretweaks.api.recipes.CustomRecipe;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.api.utils.Key;
import dev.tarna.moretweaks.config.recipes.BlastedOreBlocksConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/tarna/moretweaks/recipes/BlastedOreBlocks;", "Ldev/tarna/moretweaks/api/recipes/CustomRecipe;", "<init>", "()V", "experience", "", "cookingTime", "amount", "reload", "", "registerRecipes", "", "Lorg/bukkit/inventory/BlastingRecipe;", "createRecipe", "input", "Lorg/bukkit/Material;", "output", "MoreTweaks"})
public final class BlastedOreBlocks
extends CustomRecipe {
    private Number experience;
    private Number cookingTime;
    private Number amount;

    public BlastedOreBlocks() {
        super("blasted_ore_blocks");
    }

    @Override
    public void reload() {
        this.experience = Float.valueOf(BlastedOreBlocksConfig.INSTANCE.getExperience());
        this.cookingTime = BlastedOreBlocksConfig.INSTANCE.getCookingTime();
        this.amount = BlastedOreBlocksConfig.INSTANCE.getAmount();
    }

    @NotNull
    public List<BlastingRecipe> registerRecipes() {
        BlastingRecipe[] blastingRecipeArray = new BlastingRecipe[]{this.createRecipe(Material.RAW_IRON_BLOCK, Material.IRON_BLOCK), this.createRecipe(Material.RAW_COPPER_BLOCK, Material.COPPER_BLOCK), this.createRecipe(Material.RAW_GOLD_BLOCK, Material.GOLD_BLOCK)};
        return CollectionsKt.listOf(blastingRecipeArray);
    }

    private final BlastingRecipe createRecipe(Material input, Material output) {
        NamespacedKey namespacedKey = Key.INSTANCE.get(this.getPath() + "_" + input.name());
        Number number = this.amount;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("amount");
            number = null;
        }
        ItemStack itemStack = ItemUtilsKt.toItemStack(output, number);
        Number number2 = this.experience;
        if (number2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("experience");
            number2 = null;
        }
        float f = number2.floatValue();
        Number number3 = this.cookingTime;
        if (number3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cookingTime");
            number3 = null;
        }
        return new BlastingRecipe(namespacedKey, itemStack, input, f, number3.intValue());
    }
}

