/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.recipes;

import dev.tarna.moretweaks.api.recipes.CustomRecipe;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.api.utils.Key;
import dev.tarna.moretweaks.config.recipes.UnpackableIceConfig;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/tarna/moretweaks/recipes/UnpackableIce;", "Ldev/tarna/moretweaks/api/recipes/CustomRecipe;", "<init>", "()V", "amount", "", "reload", "", "registerRecipes", "", "Lorg/bukkit/inventory/Recipe;", "createRecipe", "material", "Lorg/bukkit/Material;", "result", "MoreTweaks"})
public final class UnpackableIce
extends CustomRecipe {
    private Number amount;

    public UnpackableIce() {
        super("unpackable_ice");
    }

    @Override
    public void reload() {
        this.amount = UnpackableIceConfig.INSTANCE.getAmount();
    }

    @Override
    @NotNull
    public List<Recipe> registerRecipes() {
        Recipe[] recipeArray = new Recipe[]{this.createRecipe(Material.PACKED_ICE, Material.ICE), this.createRecipe(Material.BLUE_ICE, Material.PACKED_ICE)};
        return CollectionsKt.listOf(recipeArray);
    }

    private final Recipe createRecipe(Material material, Material result) {
        String string = material.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        NamespacedKey namespacedKey = Key.INSTANCE.toKey("unpackable_" + string);
        Number number = this.amount;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("amount");
            number = null;
        }
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(namespacedKey, ItemUtilsKt.toItemStack(result, number)).addIngredient(material);
        Intrinsics.checkNotNullExpressionValue(shapelessRecipe, "addIngredient(...)");
        return (Recipe)shapelessRecipe;
    }
}

