/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.AlwaysDropConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/tarna/moretweaks/tweaks/AlwaysDrop;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "blocks", "", "Lorg/bukkit/Material;", "reload", "", "onBlockBreak", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "MoreTweaks"})
public final class AlwaysDrop
implements Tweak {
    @NotNull
    private final String id;
    private List<? extends Material> blocks;

    public AlwaysDrop() {
        this.id = "always_drop";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.blocks = AlwaysDropConfig.INSTANCE.getBlocks();
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        List<? extends Material> list = this.blocks;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("blocks");
            list = null;
        }
        if (!list.contains(block2.getType())) {
            return;
        }
        block2.getDrops().clear();
        World world = block2.getWorld();
        Location location = block2.getLocation();
        Material material = block2.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        world.dropItemNaturally(location, ItemUtilsKt.toItemStack$default(material, 0, 1, null));
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

