/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.ChickenSheddingConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/tarna/moretweaks/tweaks/ChickenShedding;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "chance", "", "drop", "Lorg/bukkit/Material;", "amount", "reload", "", "onChickenLay", "event", "Lorg/bukkit/event/entity/EntityDropItemEvent;", "MoreTweaks"})
public final class ChickenShedding
implements Tweak {
    @NotNull
    private final String id;
    private Number chance;
    private Material drop;
    private Number amount;

    public ChickenShedding() {
        this.id = "chicken_shedding";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.chance = ChickenSheddingConfig.INSTANCE.getChance();
        this.drop = ChickenSheddingConfig.INSTANCE.getDrop();
        this.amount = ChickenSheddingConfig.INSTANCE.getAmount();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onChickenLay(@NotNull EntityDropItemEvent event) {
        Number number;
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        Chicken chicken = entity instanceof Chicken ? (Chicken)entity : null;
        if (chicken == null) {
            return;
        }
        Chicken chicken2 = chicken;
        Number number2 = this.chance;
        if (number2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("chance");
            number2 = null;
        }
        if (!ChanceUtilsKt.chance(number2)) {
            return;
        }
        event.setCancelled(true);
        Location location = chicken2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        World world = location2.getWorld();
        Material material = this.drop;
        if (material == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drop");
            material = null;
        }
        if ((number = this.amount) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("amount");
            number = null;
        }
        world.dropItem(location2, ItemUtilsKt.toItemStack(material, number.intValue()));
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

