/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.BlockUtilsKt;
import dev.tarna.moretweaks.api.utils.DurationUtilsKt;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.DeadSaplingsConfig;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001cH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/tarna/moretweaks/tweaks/DeadSaplings;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "delay", "Ljava/time/Duration;", "time", "blocks", "", "Lorg/bukkit/Material;", "deadSaplingsRunnable", "Ldev/tarna/moretweaks/tweaks/DeadSaplings$DeadSaplingsRunnable;", "saplings", "", "Lorg/bukkit/Location;", "", "reload", "", "enable", "disable", "onSaplingPlace", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onSaplingBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "DeadSaplingsRunnable", "MoreTweaks"})
public final class DeadSaplings
implements Tweak {
    @NotNull
    private final String id;
    private Duration delay;
    private Duration time;
    private List<? extends Material> blocks;
    @Nullable
    private DeadSaplingsRunnable deadSaplingsRunnable;
    @NotNull
    private final Map<Location, Long> saplings = new LinkedHashMap();

    public DeadSaplings() {
        this.id = "dead_saplings";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.delay = DeadSaplingsConfig.INSTANCE.getDelay();
        this.time = DeadSaplingsConfig.INSTANCE.getTime();
        this.blocks = DeadSaplingsConfig.INSTANCE.getBlocks();
        this.disable();
        this.enable();
    }

    @Override
    public void enable() {
        block1: {
            DeadSaplingsRunnable deadSaplingsRunnable = this.deadSaplingsRunnable = new DeadSaplingsRunnable();
            if (deadSaplingsRunnable == null) break block1;
            Plugin plugin = (Plugin)this.getPlugin();
            Duration duration = this.delay;
            if (duration == null) {
                Intrinsics.throwUninitializedPropertyAccessException("delay");
                duration = null;
            }
            deadSaplingsRunnable.runTaskTimer(plugin, 0L, DurationUtilsKt.toTicks(duration));
        }
    }

    @Override
    public void disable() {
        this.saplings.clear();
        DeadSaplingsRunnable deadSaplingsRunnable = this.deadSaplingsRunnable;
        if (deadSaplingsRunnable != null) {
            deadSaplingsRunnable.cancel();
        }
        this.deadSaplingsRunnable = null;
    }

    @EventHandler
    public final void onSaplingPlace(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getAction().isRightClick()) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        List<? extends Material> list = this.blocks;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("blocks");
            list = null;
        }
        if (!list.contains(block2.getType())) {
            return;
        }
        if (!ItemUtilsKt.isSapling(item2)) {
            return;
        }
        Block block3 = block2.getRelative(0, 1, 0);
        Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
        Block aboveBlock = block3;
        aboveBlock.setType(item2.getType());
        int n = item2.getAmount();
        item2.setAmount(n + -1);
        this.saplings.put(aboveBlock.getLocation(), System.currentTimeMillis());
    }

    @EventHandler
    public final void onSaplingBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (!BlockUtilsKt.isSapling(block2)) {
            return;
        }
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (this.saplings.containsKey(location2)) {
            this.saplings.remove(location2);
        }
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Ldev/tarna/moretweaks/tweaks/DeadSaplings$DeadSaplingsRunnable;", "Lorg/bukkit/scheduler/BukkitRunnable;", "<init>", "(Ldev/tarna/moretweaks/tweaks/DeadSaplings;)V", "run", "", "MoreTweaks"})
    public final class DeadSaplingsRunnable
    extends BukkitRunnable {
        public void run() {
            DeadSaplings.this.saplings.entrySet().removeIf(arg_0 -> DeadSaplingsRunnable.run$lambda$1(arg_0 -> DeadSaplingsRunnable.run$lambda$0(DeadSaplings.this, arg_0), arg_0));
        }

        private static final boolean run$lambda$0(DeadSaplings this$0, Map.Entry entry) {
            Intrinsics.checkNotNullParameter(entry, "<destruct>");
            Location location = (Location)entry.getKey();
            long saplingTime = ((Number)entry.getValue()).longValue();
            long l = System.currentTimeMillis() - saplingTime;
            Duration duration = this$0.time;
            if (duration == null) {
                Intrinsics.throwUninitializedPropertyAccessException("time");
                duration = null;
            }
            if (l > duration.toMillis()) {
                location.getBlock().setType(Material.DEAD_BUSH);
                return true;
            }
            return false;
        }

        private static final boolean run$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

