/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.StringUtilsKt;
import dev.tarna.moretweaks.config.tweaks.DeathBookConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0018H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/tarna/moretweaks/tweaks/DeathBook;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "author", "title", "content", "", "reload", "", "deathLocations", "", "Ljava/util/UUID;", "Lorg/bukkit/Location;", "onPlayerDeath", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onPlayerRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "MoreTweaks"})
public final class DeathBook
implements Tweak {
    @NotNull
    private final String id;
    private String author;
    private String title;
    private List<String> content;
    @NotNull
    private final Map<UUID, Location> deathLocations = new LinkedHashMap();

    public DeathBook() {
        this.id = "death_book";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.author = DeathBookConfig.INSTANCE.getAuthor();
        this.title = DeathBookConfig.INSTANCE.getTitle();
        this.content = DeathBookConfig.INSTANCE.getContent();
    }

    @EventHandler
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        this.deathLocations.put(player2.getUniqueId(), player2.getLocation());
    }

    @EventHandler
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Location location = this.deathLocations.get(player2.getUniqueId());
        if (location == null) {
            return;
        }
        Location location2 = location;
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        ItemMeta itemMeta = book.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.BookMeta");
        BookMeta meta = (BookMeta)itemMeta;
        String string = this.author;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("author");
            string = null;
        }
        meta.author(StringUtilsKt.not(string));
        String string2 = this.title;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("title");
            string2 = null;
        }
        meta.title(StringUtilsKt.not(string2));
        Component[] componentArray = new Component[1];
        MiniMessage miniMessage = StringUtilsKt.getMm();
        List<String> list = this.content;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("content");
            list = null;
        }
        String string3 = CollectionsKt.joinToString$default(list, "\n", null, null, 0, null, null, 62, null);
        TagResolver[] tagResolverArray = new TagResolver[4];
        tagResolverArray[0] = StringUtilsKt.placeholder("x", String.valueOf(MathKt.roundToInt(location2.getX())));
        tagResolverArray[1] = StringUtilsKt.placeholder("y", String.valueOf(MathKt.roundToInt(location2.getY())));
        tagResolverArray[2] = StringUtilsKt.placeholder("z", String.valueOf(MathKt.roundToInt(location2.getZ())));
        String string4 = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        tagResolverArray[3] = StringUtilsKt.placeholder("player", string4);
        componentArray[0] = miniMessage.deserialize(string3, tagResolverArray);
        meta.addPages(componentArray);
        book.setItemMeta((ItemMeta)meta);
        componentArray = new ItemStack[]{book};
        player2.getInventory().addItem((ItemStack[])componentArray);
        this.deathLocations.remove(player2.getUniqueId());
    }

    @EventHandler
    public final void onQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.deathLocations.remove(event.getPlayer().getUniqueId());
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

