/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.config.options.impl.MessageTypeOption;
import dev.tarna.moretweaks.api.lang.Translatable;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.PlayerUtilsKt;
import dev.tarna.moretweaks.config.tweaks.DurabilityPingConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/tarna/moretweaks/tweaks/DurabilityPing;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "threshold", "", "messageType", "Ldev/tarna/moretweaks/api/config/options/impl/MessageTypeOption$MessageType;", "message", "Lnet/kyori/adventure/text/Component;", "sound", "Lnet/kyori/adventure/sound/Sound;", "reload", "", "onItemDamage", "event", "Lorg/bukkit/event/player/PlayerItemDamageEvent;", "MoreTweaks"})
public final class DurabilityPing
implements Tweak {
    @NotNull
    private final String id;
    private Number threshold;
    private MessageTypeOption.MessageType messageType;
    private Component message;
    private Sound sound;

    public DurabilityPing() {
        this.id = "durability_ping";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.threshold = DurabilityPingConfig.INSTANCE.getThreshold();
        this.messageType = DurabilityPingConfig.INSTANCE.getMessageType();
        this.message = Translatable.INSTANCE.get("tweaks.durability_ping.message", new TagResolver[0]);
        this.sound = DurabilityPingConfig.INSTANCE.getSound();
    }

    @EventHandler
    public final void onItemDamage(@NotNull PlayerItemDamageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getItem();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItem(...)");
        ItemStack item2 = itemStack;
        ItemMeta itemMeta = item2.getItemMeta();
        Damageable damageable = itemMeta instanceof Damageable ? (Damageable)itemMeta : null;
        if (damageable == null) {
            return;
        }
        Damageable meta = damageable;
        short maxDurability = item2.getType().getMaxDurability();
        int durability = maxDurability - meta.getDamage();
        double percentage = (double)durability / (double)maxDurability * (double)100;
        Number number = this.threshold;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("threshold");
            number = null;
        }
        if (percentage <= number.doubleValue()) {
            Component component;
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Player player2 = player;
            MessageTypeOption.MessageType messageType = this.messageType;
            if (messageType == null) {
                Intrinsics.throwUninitializedPropertyAccessException("messageType");
                messageType = null;
            }
            if ((component = this.message) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("message");
                component = null;
            }
            PlayerUtilsKt.send(player2, messageType, component);
            Sound sound = this.sound;
            if (sound == null) {
                Intrinsics.throwUninitializedPropertyAccessException("sound");
                sound = null;
            }
            player2.playSound(sound);
        }
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }
}

