/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.event.CropTrampleEvent;
import dev.tarna.moretweaks.api.listeners.CropTrampleListener;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.config.tweaks.FeatherCropsConfig;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/tarna/moretweaks/tweaks/FeatherCrops;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "chance", "", "reload", "", "requiredCustomListeners", "", "Ljava/lang/Class;", "Ldev/tarna/moretweaks/api/listeners/CropTrampleListener;", "onCropTrample", "event", "Ldev/tarna/moretweaks/api/event/CropTrampleEvent;", "MoreTweaks"})
public final class FeatherCrops
implements Tweak {
    @NotNull
    private final String id;
    private Number chance;

    public FeatherCrops() {
        this.id = "feather_crops";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.chance = FeatherCropsConfig.INSTANCE.getChance();
    }

    @NotNull
    public List<Class<CropTrampleListener>> requiredCustomListeners() {
        return CollectionsKt.listOf(CropTrampleListener.class);
    }

    @EventHandler
    public final void onCropTrample(@NotNull CropTrampleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getCause() == CropTrampleEvent.TrampleCause.PLAYER) {
            Number number = this.chance;
            if (number == null) {
                Intrinsics.throwUninitializedPropertyAccessException("chance");
                number = null;
            }
            if (ChanceUtilsKt.chance(number)) {
                Entity entity = event.getEntity();
                Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Player");
                Player player = (Player)entity;
                ItemStack itemStack = player.getInventory().getBoots();
                if (itemStack == null) {
                    return;
                }
                ItemStack boots = itemStack;
                Map map = boots.getEnchantments();
                Intrinsics.checkNotNullExpressionValue(map, "getEnchantments(...)");
                Map enchantments = map;
                if (!enchantments.containsKey(Enchantment.FEATHER_FALLING)) {
                    return;
                }
                event.setCancelled(true);
            }
        }
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }
}

