/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.MoreShulkerShellsConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.Shulker;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/tarna/moretweaks/tweaks/MoreShulkerShells;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "amount", "", "reload", "", "onShulkerDeath", "event", "Lorg/bukkit/event/entity/EntityDeathEvent;", "MoreTweaks"})
public final class MoreShulkerShells
implements Tweak {
    @NotNull
    private final String id;
    private Number amount;

    public MoreShulkerShells() {
        this.id = "more_shulker_shells";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.amount = MoreShulkerShellsConfig.INSTANCE.getAmount();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onShulkerDeath(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof Shulker)) {
            return;
        }
        event.getDrops().clear();
        Number number = this.amount;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("amount");
            number = null;
        }
        ItemStack newDrops = ItemUtilsKt.toItemStack(Material.SHULKER_SHELL, number.intValue());
        event.getDrops().add(newDrops);
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

