/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.PaperbarkConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/tarna/moretweaks/tweaks/Paperbark;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "chance", "", "drop", "Lorg/bukkit/Material;", "amount", "logs", "", "reload", "", "onLogStrip", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "MoreTweaks"})
public final class Paperbark
implements Tweak {
    @NotNull
    private final String id;
    private Number chance;
    private Material drop;
    private Number amount;
    private List<? extends Material> logs;

    public Paperbark() {
        this.id = "paperbark";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.chance = PaperbarkConfig.INSTANCE.getChance();
        this.drop = PaperbarkConfig.INSTANCE.getDrop();
        this.amount = PaperbarkConfig.INSTANCE.getAmount();
        this.logs = PaperbarkConfig.INSTANCE.getLogs();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onLogStrip(@NotNull PlayerInteractEvent event) {
        Number number;
        Intrinsics.checkNotNullParameter(event, "event");
        Action action = event.getAction();
        Intrinsics.checkNotNullExpressionValue(action, "getAction(...)");
        Action action2 = action;
        if (action2 != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        List<? extends Material> list = this.logs;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("logs");
            list = null;
        }
        if (!list.contains(block2.getType())) {
            return;
        }
        Number number2 = this.chance;
        if (number2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("chance");
            number2 = null;
        }
        if (!ChanceUtilsKt.chance(number2)) {
            return;
        }
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        World world = location2.getWorld();
        Material material = this.drop;
        if (material == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drop");
            material = null;
        }
        if ((number = this.amount) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("amount");
            number = null;
        }
        world.dropItemNaturally(location2, ItemUtilsKt.toItemStack(material, number));
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

