/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.api.utils.StringUtilsKt;
import dev.tarna.moretweaks.config.tweaks.PetMemorialNameTagConfig;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020$H\u0007J\u0012\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013\u00a8\u0006("}, d2={"Ldev/tarna/moretweaks/tweaks/PetMemorialNameTag;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "drop", "Lorg/bukkit/Material;", "chance", "", "format", "<set-?>", "", "showDeathMessage", "getShowDeathMessage", "()Z", "setShowDeathMessage", "(Z)V", "showDeathMessage$delegate", "Lkotlin/properties/ReadWriteProperty;", "shouldBurn", "getShouldBurn", "setShouldBurn", "shouldBurn$delegate", "reload", "", "onPetDeath", "event", "Lio/papermc/paper/event/entity/TameableDeathMessageEvent;", "onRightClick", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onAnvilUse", "Lorg/bukkit/event/inventory/PrepareAnvilEvent;", "itemBurn", "Lorg/bukkit/event/entity/EntityCombustEvent;", "isMemorialNametag", "item", "Lorg/bukkit/inventory/ItemStack;", "MoreTweaks"})
public final class PetMemorialNameTag
implements Tweak {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String id;
    private Material drop;
    private Number chance;
    private String format;
    @NotNull
    private final ReadWriteProperty showDeathMessage$delegate = Delegates.INSTANCE.notNull();
    @NotNull
    private final ReadWriteProperty shouldBurn$delegate = Delegates.INSTANCE.notNull();

    public PetMemorialNameTag() {
        this.id = "pet_memorial_name_tag";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private final boolean getShowDeathMessage() {
        return (Boolean)this.showDeathMessage$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setShowDeathMessage(boolean bl) {
        this.showDeathMessage$delegate.setValue(this, $$delegatedProperties[0], bl);
    }

    private final boolean getShouldBurn() {
        return (Boolean)this.shouldBurn$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final void setShouldBurn(boolean bl) {
        this.shouldBurn$delegate.setValue(this, $$delegatedProperties[1], bl);
    }

    @Override
    public void reload() {
        this.drop = PetMemorialNameTagConfig.INSTANCE.getDrop();
        this.chance = PetMemorialNameTagConfig.INSTANCE.getChance();
        this.format = PetMemorialNameTagConfig.INSTANCE.getFormat();
        this.setShowDeathMessage(PetMemorialNameTagConfig.INSTANCE.getShowDeathMessage());
        this.setShouldBurn(PetMemorialNameTagConfig.INSTANCE.getShouldBurn());
    }

    @EventHandler
    public final void onPetDeath(@NotNull TameableDeathMessageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Tameable tameable = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(tameable, "getEntity(...)");
        Tameable pet = tameable;
        Object object = pet.customName();
        if (object == null || (object = StringUtilsKt.rawString(object)) == null) {
            return;
        }
        Object petName = object;
        Number number = this.chance;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("chance");
            number = null;
        }
        if (ChanceUtilsKt.chance(number)) {
            Material material = this.drop;
            if (material == null) {
                Intrinsics.throwUninitializedPropertyAccessException("drop");
                material = null;
            }
            ItemStack nametag = ItemUtilsKt.toItemStack$default(material, 0, 1, null);
            String string = this.format;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("format");
                string = null;
            }
            ItemUtilsKt.setName(nametag, StringsKt.replace$default(string, "<name>", (String)petName, false, 4, null));
            Boolean bl = true;
            PersistentDataType persistentDataType = PersistentDataType.BOOLEAN;
            Intrinsics.checkNotNullExpressionValue(persistentDataType, "BOOLEAN");
            ItemUtilsKt.setValue(nametag, "pet_memorial", bl, persistentDataType);
            Component component = event.deathMessage();
            Intrinsics.checkNotNullExpressionValue(component, "deathMessage(...)");
            String string2 = StringUtilsKt.rawString(component);
            PersistentDataType persistentDataType2 = PersistentDataType.STRING;
            Intrinsics.checkNotNullExpressionValue(persistentDataType2, "STRING");
            ItemUtilsKt.setValue(nametag, "death_message", string2, persistentDataType2);
            World world = pet.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            Location location = pet.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            ItemUtilsKt.dropItemWithoutVelocity$default(world, location, nametag, false, 4, null);
        }
    }

    @EventHandler
    public final void onRightClick(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        if (!this.isMemorialNametag(item2)) {
            return;
        }
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        String string = (String)ItemUtilsKt.getValue(item2, "death_message", persistentDataType);
        if (string == null) {
            return;
        }
        String deathMessage = string;
        event.getPlayer().sendMessage(deathMessage);
    }

    @EventHandler
    public final void onAnvilUse(@NotNull PrepareAnvilEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        AnvilInventory anvilInventory = event.getInventory();
        Intrinsics.checkNotNullExpressionValue(anvilInventory, "getInventory(...)");
        AnvilInventory anvilInventory2 = anvilInventory;
        ItemStack firstItem = anvilInventory2.getFirstItem();
        ItemStack secondItem = anvilInventory2.getSecondItem();
        if (this.isMemorialNametag(firstItem) || this.isMemorialNametag(secondItem)) {
            event.setResult(null);
        }
    }

    @EventHandler
    public final void itemBurn(@NotNull EntityCombustEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        ItemStack itemStack = entity instanceof ItemStack ? (ItemStack)entity : null;
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        if (this.isMemorialNametag(item2)) {
            event.setCancelled(!this.getShouldBurn());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMemorialNametag(ItemStack item2) {
        if (item2 == null) return false;
        PersistentDataType persistentDataType = PersistentDataType.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "BOOLEAN");
        if (!ItemUtilsKt.hasValue(item2, "pet_memorial", persistentDataType)) return false;
        return true;
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(PetMemorialNameTag.class, "showDeathMessage", "getShowDeathMessage()Z", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(PetMemorialNameTag.class, "shouldBurn", "getShouldBurn()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

