/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.config.tweaks.RandomCreeperFuseConfig;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/tarna/moretweaks/tweaks/RandomCreeperFuse;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "minFuse", "", "maxFuse", "reload", "", "onCreeperSpawn", "event", "Lorg/bukkit/event/entity/CreatureSpawnEvent;", "MoreTweaks"})
public final class RandomCreeperFuse
implements Tweak {
    @NotNull
    private final String id;
    private Number minFuse;
    private Number maxFuse;

    public RandomCreeperFuse() {
        this.id = "random_creeper_fuse";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.minFuse = RandomCreeperFuseConfig.INSTANCE.getMinFuse();
        this.maxFuse = RandomCreeperFuseConfig.INSTANCE.getMaxFuse();
    }

    @EventHandler
    public final void onCreeperSpawn(@NotNull CreatureSpawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LivingEntity livingEntity = event.getEntity();
        Creeper creeper = livingEntity instanceof Creeper ? (Creeper)livingEntity : null;
        if (creeper == null) {
            return;
        }
        Creeper creeper2 = creeper;
        Number number = this.minFuse;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("minFuse");
            number = null;
        }
        int n = number.intValue();
        Number number2 = this.maxFuse;
        if (number2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("maxFuse");
            number2 = null;
        }
        int rand = RangesKt.random(new IntRange(n, number2.intValue()), (Random)Random.Default);
        creeper2.setMaxFuseTicks(rand);
        creeper2.setFuseTicks(rand);
        Collection collection = creeper2.getLocation().getNearbyPlayers(10.0);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyPlayers(...)");
        Player player = (Player)CollectionsKt.firstOrNull(collection);
        if (player == null) {
            return;
        }
        Player nearbyPlayers = player;
        nearbyPlayers.sendMessage("A creeper has spawned with a fuse of " + creeper2.getMaxFuseTicks() + " ticks!");
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

