/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ldev/tarna/moretweaks/tweaks/SlimeCream;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "onRightClick", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "drop", "location", "Lorg/bukkit/Location;", "item", "Lorg/bukkit/Material;", "MoreTweaks"})
public final class SlimeCream
implements Tweak {
    @NotNull
    private final String id;

    public SlimeCream() {
        this.id = "slime_cream";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @EventHandler
    public final void onRightClick(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getAction().isRightClick()) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        if (item2.getType() != Material.SLIME_BALL && item2.getType() != Material.MAGMA_CREAM) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        if (!ItemUtilsKt.isCauldron(block2)) {
            return;
        }
        if (item2.getType() == Material.SLIME_BALL && block2.getType() == Material.LAVA_CAULDRON) {
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.drop(location, Material.MAGMA_CREAM);
        } else if (item2.getType() == Material.MAGMA_CREAM && block2.getType() == Material.WATER_CAULDRON) {
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.drop(location, Material.SLIME_BALL);
        } else {
            return;
        }
        int n = item2.getAmount();
        item2.setAmount(n + -1);
    }

    private final void drop(Location location, Material item2) {
        World world = location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        Location location2 = location.add(0.5, 1.0, 0.5);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        ItemUtilsKt.dropItemWithoutVelocity(world, location2, ItemUtilsKt.toItemStack$default(item2, 0, 1, null), false);
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    public void reload() {
        Tweak.DefaultImpls.reload(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

