/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.BlockUtilsKt;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.config.tweaks.WeakenedBedrockConfig;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/tarna/moretweaks/tweaks/WeakenedBedrock;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "radius", "", "chance", "speed", "worlds", "", "Lorg/bukkit/World;", "reload", "", "onLingeringPotionThrow", "event", "Lorg/bukkit/event/entity/LingeringPotionSplashEvent;", "MoreTweaks"})
public final class WeakenedBedrock
implements Tweak {
    @NotNull
    private final String id;
    private Number radius;
    private Number chance;
    private Number speed;
    private List<? extends World> worlds;

    public WeakenedBedrock() {
        this.id = "weakened_bedrock";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.radius = WeakenedBedrockConfig.INSTANCE.getRadius();
        this.chance = WeakenedBedrockConfig.INSTANCE.getChance();
        this.speed = WeakenedBedrockConfig.INSTANCE.getSpeed();
        this.worlds = WeakenedBedrockConfig.INSTANCE.getWorlds();
    }

    @EventHandler
    public final void onLingeringPotionThrow(@NotNull LingeringPotionSplashEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        AreaEffectCloud areaEffectCloud = event.getAreaEffectCloud();
        Intrinsics.checkNotNullExpressionValue(areaEffectCloud, "getAreaEffectCloud(...)");
        AreaEffectCloud areaEffectCloud2 = areaEffectCloud;
        PotionType potionType = areaEffectCloud2.getBasePotionType();
        if (potionType == null) {
            return;
        }
        PotionType potionType2 = potionType;
        if (potionType2 != PotionType.WEAKNESS && potionType2 != PotionType.LONG_WEAKNESS) {
            return;
        }
        List<? extends World> list = this.worlds;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worlds");
            list = null;
        }
        if (!list.contains(areaEffectCloud2.getWorld())) {
            return;
        }
        Location location = areaEffectCloud2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Number number = this.radius;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("radius");
            number = null;
        }
        Material[] materialArray = new Material[]{Material.BEDROCK};
        List blocks = CollectionsKt.shuffled((Iterable)BlockUtilsKt.getNearbyBlocks(location, number.intValue(), materialArray));
        int n = ((Collection)blocks).size();
        for (int i = 0; i < n; ++i) {
            BukkitScheduler bukkitScheduler = this.getPlugin().getServer().getScheduler();
            Plugin plugin = (Plugin)this.getPlugin();
            Runnable runnable = () -> WeakenedBedrock.onLingeringPotionThrow$lambda$0(this, blocks, i);
            Number number2 = this.speed;
            if (number2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("speed");
                number2 = null;
            }
            bukkitScheduler.runTaskLater(plugin, runnable, (long)number2.intValue() * (long)i);
        }
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }

    private static final void onLingeringPotionThrow$lambda$0(WeakenedBedrock this$0, List $blocks, int $i) {
        Number number = this$0.chance;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("chance");
            number = null;
        }
        if (ChanceUtilsKt.chance(number)) {
            ((Block)$blocks.get($i)).setType(Material.COBBLESTONE);
        }
    }
}

