/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.WitherFleshConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/tarna/moretweaks/tweaks/WitherFlesh;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "chance", "", "amount", "reload", "", "onDeath", "event", "Lorg/bukkit/event/entity/EntityDeathEvent;", "killedByWither", "", "Lorg/bukkit/event/entity/EntityDamageEvent;", "MoreTweaks"})
public final class WitherFlesh
implements Tweak {
    @NotNull
    private final String id;
    private Number chance;
    private Number amount;

    public WitherFlesh() {
        this.id = "wither_flesh";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.chance = WitherFleshConfig.INSTANCE.getChance();
        this.amount = WitherFleshConfig.INSTANCE.getAmount();
    }

    @EventHandler
    public final void onDeath(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        LivingEntity entity = livingEntity;
        EntityDamageEvent entityDamageEvent = entity.getLastDamageCause();
        if (entityDamageEvent == null) {
            return;
        }
        EntityDamageEvent damage = entityDamageEvent;
        if (!this.killedByWither(damage)) {
            return;
        }
        Number number = this.chance;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("chance");
            number = null;
        }
        if (!ChanceUtilsKt.chance(number)) {
            return;
        }
        event.getDrops().clear();
        List list = event.getDrops();
        Number number2 = this.amount;
        if (number2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("amount");
            number2 = null;
        }
        list.add(ItemUtilsKt.toItemStack(Material.ROTTEN_FLESH, number2));
    }

    private final boolean killedByWither(EntityDamageEvent event) {
        boolean bl;
        if (event.getCause() == EntityDamageEvent.DamageCause.WITHER) {
            bl = true;
        } else if (event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE && event instanceof EntityDamageByEntityEvent) {
            Projectile projectile = (Projectile)((EntityDamageByEntityEvent)event).getDamager();
            if (projectile == null) {
                return false;
            }
            Projectile projectile2 = projectile;
            bl = projectile2.getType() == EntityType.WITHER_SKULL;
        } else if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && event instanceof EntityDamageByEntityEvent) {
            Entity entity = ((EntityDamageByEntityEvent)event).getDamager();
            Intrinsics.checkNotNullExpressionValue(entity, "getDamager(...)");
            Entity entity2 = entity;
            bl = entity2.getType() == EntityType.WITHER || entity2.getType() == EntityType.WITHER_SKULL;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

