/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.api.utils.PlayerUtilsKt;
import dev.tarna.moretweaks.config.tweaks.XPBottlingConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/tarna/moretweaks/tweaks/XPBottling;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "expPerBottle", "", "reload", "", "onRightClickTable", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onRightClickBottle", "MoreTweaks"})
public final class XPBottling
implements Tweak {
    @NotNull
    private final String id;
    private Number expPerBottle;

    public XPBottling() {
        this.id = "xp_bottling";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        this.expPerBottle = XPBottlingConfig.INSTANCE.getExpPerBottle();
    }

    @EventHandler
    public final void onRightClickTable(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getAction().isRightClick()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        if (block2.getType() != Material.ENCHANTING_TABLE) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        if (item2.getType() != Material.GLASS_BOTTLE) {
            return;
        }
        event.setCancelled(true);
        Number number = this.expPerBottle;
        if (number == null) {
            Intrinsics.throwUninitializedPropertyAccessException("expPerBottle");
            number = null;
        }
        int expPerBottle = number.intValue();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        int exp = player2.calculateTotalExperiencePoints();
        if (exp < expPerBottle) {
            return;
        }
        player2.setExperienceLevelAndProgress(exp - expPerBottle);
        ItemStack bottle = ItemUtilsKt.toItemStack$default(Material.EXPERIENCE_BOTTLE, 0, 1, null);
        Integer n = expPerBottle;
        PersistentDataType persistentDataType = PersistentDataType.INTEGER;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "INTEGER");
        ItemUtilsKt.setValue(bottle, "xp", n, persistentDataType);
        ItemUtilsKt.setName(bottle, "+" + expPerBottle + " XP");
        PlayerUtilsKt.giveOrDrop(player2, bottle);
        int n2 = item2.getAmount();
        item2.setAmount(n2 + -1);
    }

    @EventHandler
    public final void onRightClickBottle(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getAction().isRightClick()) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        if (item2.getType() != Material.EXPERIENCE_BOTTLE) {
            return;
        }
        PersistentDataType persistentDataType = PersistentDataType.INTEGER;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "INTEGER");
        Integer n = (Integer)ItemUtilsKt.getValue(item2, "xp", persistentDataType);
        if (n == null) {
            return;
        }
        int exp = n;
        event.getPlayer().giveExp(exp);
        int n2 = item2.getAmount();
        item2.setAmount(n2 + -1);
        event.setCancelled(true);
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

