/*
 * Decompiled with CFR 0.152.
 */
package dev.tarna.moretweaks.tweaks;

import dev.tarna.moretweaks.MoreTweaks;
import dev.tarna.moretweaks.api.tweaks.Tweak;
import dev.tarna.moretweaks.api.utils.ChanceUtilsKt;
import dev.tarna.moretweaks.api.utils.ItemUtilsKt;
import dev.tarna.moretweaks.config.tweaks.ZombiePickaxeConfig;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/tarna/moretweaks/tweaks/ZombiePickaxe;", "Ldev/tarna/moretweaks/api/tweaks/Tweak;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "pickaxeChances", "", "Lorg/bukkit/Material;", "", "reload", "", "onZombieSpawn", "event", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "MoreTweaks"})
public final class ZombiePickaxe
implements Tweak {
    @NotNull
    private final String id;
    private Map<Material, Integer> pickaxeChances;

    public ZombiePickaxe() {
        this.id = "zombie_pickaxe";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void reload() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Material.AIR, ZombiePickaxeConfig.INSTANCE.getNoneChance()), TuplesKt.to(Material.WOODEN_PICKAXE, ZombiePickaxeConfig.INSTANCE.getWoodenPickaxeChance()), TuplesKt.to(Material.STONE_PICKAXE, ZombiePickaxeConfig.INSTANCE.getStonePickaxeChance()), TuplesKt.to(Material.IRON_PICKAXE, ZombiePickaxeConfig.INSTANCE.getIronPickaxeChance()), TuplesKt.to(Material.GOLDEN_PICKAXE, ZombiePickaxeConfig.INSTANCE.getGoldenPickaxeChance()), TuplesKt.to(Material.DIAMOND_PICKAXE, ZombiePickaxeConfig.INSTANCE.getDiamondPickaxeChance()), TuplesKt.to(Material.NETHERITE_PICKAXE, ZombiePickaxeConfig.INSTANCE.getNetheritePickaxeChance())};
        this.pickaxeChances = MapsKt.mapOf(pairArray);
    }

    @EventHandler
    public final void onZombieSpawn(@NotNull EntitySpawnEvent event) {
        block5: {
            Material pickaxe;
            Intrinsics.checkNotNullParameter(event, "event");
            Entity entity = event.getEntity();
            LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity == null) {
                return;
            }
            LivingEntity entity2 = livingEntity;
            if (entity2.getType() != EntityType.ZOMBIE) {
                return;
            }
            if (entity2.getLocation().getY() > (double)ZombiePickaxeConfig.INSTANCE.getYLevel()) {
                return;
            }
            Map<Material, Integer> map = this.pickaxeChances;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException("pickaxeChances");
                map = null;
            }
            if ((pickaxe = ChanceUtilsKt.weightedChance(map)) == Material.AIR) {
                return;
            }
            EntityEquipment entityEquipment = entity2.getEquipment();
            if (entityEquipment == null) break block5;
            entityEquipment.setItemInMainHand(ItemUtilsKt.toItemStack$default(pickaxe, 0, 1, null));
        }
    }

    @Override
    @NotNull
    public MoreTweaks getPlugin() {
        return Tweak.DefaultImpls.getPlugin(this);
    }

    @Override
    @NotNull
    public String getPrettyName() {
        return Tweak.DefaultImpls.getPrettyName(this);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tweak.DefaultImpls.getDescription(this);
    }

    @Override
    public void enable() {
        Tweak.DefaultImpls.enable(this);
    }

    @Override
    public void disable() {
        Tweak.DefaultImpls.disable(this);
    }

    @Override
    @NotNull
    public List<Class<? extends Listener>> requiredCustomListeners() {
        return Tweak.DefaultImpls.requiredCustomListeners(this);
    }
}

