/*
 * Decompiled with CFR 0.152.
 */
package me.tech.mcchestui.attached;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.tech.mcchestui.attached.AttachedInventoryCache;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/tech/mcchestui/attached/MemoryAttachedInventoryCache;", "Lme/tech/mcchestui/attached/AttachedInventoryCache;", "()V", "cachedInventory", "", "Ljava/util/UUID;", "", "Lorg/bukkit/inventory/ItemStack;", "restoreInventory", "", "player", "Lorg/bukkit/entity/Player;", "saveInventory", "mc-chestui-plus"})
public final class MemoryAttachedInventoryCache
implements AttachedInventoryCache {
    @NotNull
    public static final MemoryAttachedInventoryCache INSTANCE = new MemoryAttachedInventoryCache();
    @NotNull
    private static final Map<UUID, ItemStack[]> cachedInventory = new LinkedHashMap();

    private MemoryAttachedInventoryCache() {
    }

    @Override
    public boolean saveInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Map<UUID, ItemStack[]> map = cachedInventory;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uUID2 = uUID;
        ItemStack[] itemStackArray = player.getInventory().getStorageContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getStorageContents(...)");
        ItemStack[] itemStackArray2 = itemStackArray;
        map.put(uUID2, itemStackArray2);
        return true;
    }

    @Override
    public boolean restoreInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack[] itemStackArray = cachedInventory.get(player.getUniqueId());
        if (itemStackArray == null) {
            return false;
        }
        ItemStack[] inventory = itemStackArray;
        player.getInventory().setStorageContents(inventory);
        cachedInventory.remove(player.getUniqueId());
        return true;
    }
}

