/*
 * Decompiled with CFR 0.152.
 */
package com.example.simplerestart;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.server.MinecraftServer;

public class SimpleRestartMod
implements ModInitializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/simplerestart.json");
    private Timer currentTimer = null;
    private Config config;

    public void onInitialize() {
        this.loadConfig();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"srestart").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"restart").then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)3, (int)3600)).executes(ctx -> {
            int seconds = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            this.scheduleRestart(server, seconds);
            LocalTime now = LocalTime.now().plusSeconds(seconds);
            String restartAt = now.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a76\u2699 \u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d \u0440\u0435\u0441\u0442\u0430\u0440\u0442 \u0447\u0435\u0440\u0435\u0437 " + seconds + " \u0441\u0435\u043a\u0443\u043d\u0434 (" + restartAt + ")")), false);
            return 1;
        })))).then(class_2170.method_9247((String)"cancel").executes(ctx -> {
            if (this.currentTimer != null) {
                this.currentTimer.cancel();
                this.currentTimer = null;
                ((class_2168)ctx.getSource()).method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)this.config.messages.cancelled), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7e\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0440\u0435\u0441\u0442\u0430\u0440\u0442\u0430."), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
            this.loadConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d."), false);
            return 1;
        }))));
    }

    private void scheduleRestart(final MinecraftServer server, int seconds) {
        int[] warnings;
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
            this.currentTimer = null;
        }
        this.currentTimer = new Timer();
        for (final int warn : warnings = new int[]{60, 30, 10, 5, 3, 2, 1}) {
            if (seconds <= warn) continue;
            this.currentTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    server.execute(() -> {
                        server.method_3760().method_43514((class_2561)class_2561.method_43470((String)SimpleRestartMod.this.config.messages.warning.replace("{time}", String.valueOf(warn))), false);
                        if (warn <= 5) {
                            for (class_3222 p : server.method_3760().method_14571()) {
                                p.method_5783(class_3417.field_14627, 1.0f, 1.0f);
                            }
                        }
                    });
                }
            }, (long)(seconds - warn) * 1000L);
        }
        this.currentTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                server.execute(() -> {
                    server.method_3760().method_43514((class_2561)class_2561.method_43470((String)SimpleRestartMod.this.config.messages.restarting), false);
                    try {
                        server.method_3747(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }, (long)seconds * 1000L);
    }

    private void loadConfig() {
        block8: {
            try {
                if (!CONFIG_FILE.exists()) {
                    CONFIG_FILE.getParentFile().mkdirs();
                    this.config = new Config();
                    this.saveConfig();
                    System.out.println("[SimpleRestart] \u0421\u043e\u0437\u0434\u0430\u043d \u043d\u043e\u0432\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433.");
                    break block8;
                }
                try (FileReader reader = new FileReader(CONFIG_FILE);){
                    this.config = (Config)GSON.fromJson((Reader)reader, Config.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.config = new Config();
            }
        }
    }

    private void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this.config, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Config {
        Messages messages = new Messages();

        private Config() {
        }

        static class Messages {
            String warning = "\u00a7e\u26a0 \u0420\u0435\u0441\u0442\u0430\u0440\u0442 \u0447\u0435\u0440\u0435\u0437 {time} \u0441\u0435\u043a\u0443\u043d\u0434!";
            String restarting = "\u00a7c\u23f3 \u0421\u0435\u0440\u0432\u0435\u0440 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f...";
            String cancelled = "\u00a7c\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0442\u0430\u0440\u0442 \u043e\u0442\u043c\u0435\u043d\u0451\u043d.";

            Messages() {
            }
        }
    }
}

