/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import kgg.translator.TranslatorManager;
import kgg.translator.option.Option;
import kgg.translator.util.ConfigUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TranslatorConfig {
    private static final File file = new File("config", "translator.json");
    private static final File optionFile = new File("config", "translator_option.json");
    private static final Logger LOGGER = LogManager.getLogger(TranslatorConfig.class);

    public static boolean readFile() {
        JsonObject options;
        try {
            JsonObject config = ConfigUtil.load(file);
            boolean b = TranslatorConfig.readConfig(config);
            assert (b);
            options = ConfigUtil.load(optionFile);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read config file", (Throwable)e);
            return false;
        }
        return TranslatorConfig.readOptions(options);
    }

    public static boolean writeFile() {
        JsonObject config = new JsonObject();
        if (TranslatorConfig.writeConfig(config)) {
            try {
                ConfigUtil.save(file, config);
                JsonObject options = new JsonObject();
                boolean b = TranslatorConfig.writeOptions(options);
                assert (b);
                ConfigUtil.save(optionFile, options);
                LOGGER.info("Config written successfully");
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to write config file", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean writeConfig(JsonObject config) {
        config.addProperty("from", TranslatorManager.getFrom());
        config.addProperty("to", TranslatorManager.getTo());
        config.addProperty("current", TranslatorManager.getCurrent().getName());
        TranslatorManager.getTranslators().forEach(translator -> {
            if (translator.isConfigured()) {
                JsonObject object = new JsonObject();
                translator.write(object);
                config.add(translator.getName(), (JsonElement)object);
            }
        });
        return true;
    }

    public static boolean readConfig(JsonObject config) {
        try {
            TranslatorManager.setFrom(config.get("from").getAsString());
            TranslatorManager.setTo(config.get("to").getAsString());
            String currentTranslator = config.get("current").getAsString();
            TranslatorManager.getTranslators().forEach(translator -> {
                JsonElement element = config.get(translator.getName());
                if (element != null) {
                    JsonObject translatorConfig = element.getAsJsonObject();
                    try {
                        translator.read(translatorConfig);
                    }
                    catch (Exception e) {
                        LOGGER.error("{} failed to read config", (Object)translator.getName(), (Object)e);
                    }
                }
                if (translator.getName().equals(currentTranslator)) {
                    TranslatorManager.setTranslator(translator);
                }
            });
            LOGGER.info("Config read successfully");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read config", (Throwable)e);
            return false;
        }
    }

    private static boolean readOptions(JsonObject config) {
        try {
            for (Option option : Option.getOptions()) {
                JsonElement element = config.get(option.name);
                if (element == null) continue;
                option.setEnable(element.getAsBoolean());
            }
            LOGGER.info("Options read successfully");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read options", (Throwable)e);
            return false;
        }
    }

    private static boolean writeOptions(JsonObject config) {
        for (Option option : Option.getOptions()) {
            config.addProperty(option.name, Boolean.valueOf(option.isEnable()));
        }
        return true;
    }
}

