/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import kgg.translator.exception.NoTranslatorException;
import kgg.translator.exception.NotConfiguredException;
import kgg.translator.exception.TranslateException;
import kgg.translator.ocrtrans.ResRegion;
import kgg.translator.translator.Translator;
import kgg.translator.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TranslatorManager {
    private static final Logger LOGGER = LogManager.getLogger(TranslatorManager.class);
    private static Translator current;
    private static final List<Translator> translators;
    private static String from;
    private static String to;
    private static final LoadingCache<String, String> cache;

    public static String getFromCache(String text) {
        return (String)cache.getIfPresent((Object)text);
    }

    public static ResRegion[] ocrtrans(byte[] img) throws TranslateException {
        return TranslatorManager.ocrtrans(TranslatorManager.getCurrent(), img, TranslatorManager.getFrom(), TranslatorManager.getTo());
    }

    public static String cachedTranslate(String text) throws TranslateException {
        try {
            return (String)cache.get((Object)text);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TranslateException) {
                TranslateException c = (TranslateException)throwable;
                throw c;
            }
            throw new TranslateException(e.getCause());
        }
    }

    public static String translate(String text) throws TranslateException {
        return TranslatorManager.translate(text, TranslatorManager.getCurrent(), TranslatorManager.getFrom(), TranslatorManager.getTo());
    }

    public static String translate(String text, Translator translator) throws TranslateException {
        return TranslatorManager.translate(text, translator, TranslatorManager.getFrom(), TranslatorManager.getTo());
    }

    public static String translate(String text, Translator translator, String from, String to) throws TranslateException {
        if (StringUtil.isBlank(text)) {
            return text;
        }
        if (StringUtils.isNumeric((CharSequence)text)) {
            return text;
        }
        TranslatorManager.checkTranslator(translator);
        try {
            String translate = translator.translate(text, from, to);
            LOGGER.info("{} translate from {} to {}: \"{}\" -> \"{}\"", (Object)translator, (Object)from, (Object)to, (Object)TranslatorManager.getOutString(text), (Object)TranslatorManager.getOutString(translate));
            return translate;
        }
        catch (Exception e) {
            LOGGER.error("{} translate from {} to {} failed: \"{}\"", (Object)translator, (Object)from, (Object)to, (Object)TranslatorManager.getOutString(text), (Object)e);
            if (e instanceof TranslateException) {
                TranslateException c = (TranslateException)e;
                throw c;
            }
            throw new TranslateException(e);
        }
    }

    public static ResRegion[] ocrtrans(Translator translator, byte[] img, String from, String to) throws TranslateException {
        TranslatorManager.checkTranslator(translator);
        LOGGER.info("{} ocrtrans, from {} to {}", (Object)translator, (Object)from, (Object)to);
        try {
            return translator.ocrtrans(img, from, to);
        }
        catch (Exception e) {
            LOGGER.error("{} ocrtrans, from {} to {} failed:", (Object)translator, (Object)from, (Object)to, (Object)e);
            if (e instanceof TranslateException) {
                TranslateException c = (TranslateException)e;
                throw c;
            }
            throw new TranslateException(e);
        }
    }

    private static void checkTranslator(Translator translator) throws TranslateException {
        if (translator == null) {
            throw new NoTranslatorException();
        }
        if (!translator.isConfigured()) {
            throw new NotConfiguredException(translator);
        }
    }

    public static void clearCache() {
        LOGGER.info("Clear cache");
        cache.invalidateAll();
    }

    public static Translator getCurrent() {
        return current;
    }

    public static boolean setTranslator(Translator translator) {
        LOGGER.info("Set current translator to {}", (Object)translator);
        if (current != translator) {
            if (current != null && translator.getLanguageProperties() != null && current.getLanguageProperties() != null) {
                String originalFrom = current.getLanguageProperties().getKeysByValue(from);
                String originalTo = current.getLanguageProperties().getKeysByValue(to);
                if (originalFrom != null && originalTo != null) {
                    String newFrom = translator.getLanguageProperties().getProperty(originalFrom);
                    String newTo = translator.getLanguageProperties().getProperty(originalTo);
                    if (newFrom != null && newTo != null) {
                        TranslatorManager.setFrom(newFrom);
                        TranslatorManager.setTo(newTo);
                        current = translator;
                        return true;
                    }
                }
            }
            current = translator;
            return false;
        }
        return true;
    }

    public static void addTranslator(Translator translator) {
        LOGGER.info("Add translator {}", (Object)translator);
        if (translators.isEmpty()) {
            TranslatorManager.setTranslator(translator);
        } else if (!TranslatorManager.getCurrent().isConfigured() && translator.isConfigured()) {
            TranslatorManager.setTranslator(translator);
        }
        translators.add(translator);
    }

    public static String getTo() {
        return to;
    }

    public static void setTo(String defaultTo) {
        to = defaultTo;
    }

    public static String getFrom() {
        return from;
    }

    public static void setFrom(String defaultFrom) {
        from = defaultFrom;
    }

    public static List<Translator> getTranslators() {
        return translators;
    }

    private static String getOutString(String text) {
        if (text.length() > 20) {
            return text.substring(0, 20) + "...";
        }
        return text;
    }

    static {
        translators = new LinkedList<Translator>();
        from = "auto";
        to = "zh-cn";
        cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, String>(){

            @NotNull
            public String load(@NotNull String key) throws Exception {
                return TranslatorManager.translate(key);
            }
        });
    }
}

