/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator.command;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import kgg.translator.TranslatorConfig;
import kgg.translator.TranslatorManager;
import kgg.translator.command.LangArgumentType;
import kgg.translator.handler.TranslateHelper;
import kgg.translator.translator.Translator;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class TranslateConfigCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder root = ClientCommandManager.literal((String)"transconfig");
        root.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"language").executes(TranslateConfigCommand::queryLanguage)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"from", (ArgumentType)LangArgumentType.lang()).executes(context -> {
            String from = LangArgumentType.getLanguage((CommandContext<FabricClientCommandSource>)context, "from");
            TranslatorManager.setFrom(from);
            return TranslateConfigCommand.queryLanguage((CommandContext<FabricClientCommandSource>)context);
        })).then(ClientCommandManager.argument((String)"to", (ArgumentType)LangArgumentType.lang()).executes(context -> {
            String from = LangArgumentType.getLanguage((CommandContext<FabricClientCommandSource>)context, "from");
            String to = LangArgumentType.getLanguage((CommandContext<FabricClientCommandSource>)context, "to");
            TranslatorManager.setFrom(from);
            TranslatorManager.setTo(to);
            return TranslateConfigCommand.queryLanguage((CommandContext<FabricClientCommandSource>)context);
        }))));
        LiteralArgumentBuilder selectNode = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"translator").executes(TranslateConfigCommand::queryTranslator);
        TranslatorManager.getTranslators().forEach(translator -> {
            LiteralArgumentBuilder subNode = (LiteralArgumentBuilder)ClientCommandManager.literal((String)translator.getName()).executes(context -> {
                boolean b = TranslatorManager.setTranslator(translator);
                int a = TranslateConfigCommand.queryTranslator((CommandContext<FabricClientCommandSource>)context);
                if (!b) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u672a\u80fd\u81ea\u52a8\u5207\u6362\u8bed\u8a00\uff0c\u9700\u8981\u624b\u52a8\u4fee\u6539\u8bed\u8a00"));
                }
                return a;
            });
            translator.register((LiteralArgumentBuilder<FabricClientCommandSource>)subNode);
            selectNode.then((ArgumentBuilder)subNode);
        });
        root.then((ArgumentBuilder)selectNode);
        root.then(ClientCommandManager.literal((String)"save").executes(context -> {
            if (TranslatorConfig.writeFile()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"OK"));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Failed to save config"));
            }
            return 0;
        }));
        root.then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"json", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String str = StringArgumentType.getString((CommandContext)context, (String)"json");
            try {
                JsonObject object = JsonParser.parseString((String)str).getAsJsonObject();
                boolean read = TranslatorConfig.readConfig(object);
                if (read) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"OK"));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Failed to load config"));
                }
                return 0;
            }
            catch (JsonSyntaxException e) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Invalid json"));
                return 0;
            }
        })));
        root.then(ClientCommandManager.literal((String)"clearcache").executes(context -> {
            TranslatorManager.clearCache();
            TranslateHelper.clearCache();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"OK"));
            return 0;
        }));
        root.then(ClientCommandManager.literal((String)"config").executes(context -> {
            JsonObject object = new JsonObject();
            TranslatorConfig.writeConfig(object);
            String txt = object.toString();
            class_5250 message = class_2561.method_43470((String)txt);
            message.method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, txt)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u70b9\u51fb\u590d\u5236"))));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)message);
            return 0;
        }));
        dispatcher.register(root);
    }

    private static int queryLanguage(CommandContext<FabricClientCommandSource> context) {
        class_5250 message = class_2561.method_43470((String)"\u5f53\u524d\u4ece%s\u7ffb\u8bd1\u6210%s".formatted(TranslatorManager.getFrom(), TranslatorManager.getTo()));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)message);
        return 0;
    }

    private static int queryTranslator(CommandContext<FabricClientCommandSource> context) {
        Translator translator = TranslatorManager.getCurrent();
        class_5250 message = class_2561.method_43470((String)"\u5f53\u524d\u4f7f\u7528\u7684\u7ffb\u8bd1\u5668\u4e3a%s".formatted(translator));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)message);
        message = translator.isConfigured() ? class_2561.method_43470((String)"%s\u5df2\u914d\u7f6e".formatted(translator)).method_54663(65280) : class_2561.method_43470((String)"%s\u672a\u914d\u7f6e".formatted(translator)).method_54663(0xFF0000);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)message);
        return 0;
    }
}

