/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator.handler;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import kgg.translator.TranslatorManager;
import kgg.translator.option.ChatOption;
import kgg.translator.util.StringUtil;
import kgg.translator.util.TextUtil;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChatHandler {
    private static final Logger LOGGER = LogManager.getLogger(ChatHandler.class);
    private static final ArrayList<class_5250> translatingTexts = new ArrayList();
    private static final class_2561 TRANSLATING_TIP = class_2561.method_43470((String)"[\u7ffb\u8bd1\u4e2d]").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)2259711)).method_10958((class_2558)new TranslateClickEvent(null)));
    private static final class_2568 TRANSLATE_HOVER_EVENT = new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u70b9\u51fb\u91cd\u65b0\u7ffb\u8bd1"));

    private static void refresh() {
        class_310.method_1551().field_1705.method_1743().method_44813();
    }

    public static void addTip() {
        if (!ChatOption.chatTip.isEnable()) {
            return;
        }
        for (class_303 message : class_310.method_1551().field_1705.method_1743().field_2061) {
            class_5250 text = ChatHandler.initText(message.comp_893());
            ChatHandler.addTip(text);
        }
        ChatHandler.refresh();
    }

    private static void addTip(class_5250 text) {
        if (TextUtil.isSystemText((class_2561)text) || StringUtil.isBlank(text.getString())) {
            return;
        }
        if (translatingTexts.contains(text)) {
            text.method_27693(" ").method_10852(TRANSLATING_TIP);
        } else if (ChatHandler.getTranslateClickEvent(text) == null) {
            text.method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"[\u7ffb\u8bd1]").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)65522)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u70b9\u51fb\u7ffb\u8bd1"))).method_10958((class_2558)new TranslateClickEvent(text)).method_10975(text.getString())));
        }
    }

    public static void removeTip() {
        for (class_303 message : class_310.method_1551().field_1705.method_1743().field_2061) {
            class_5250 text = ChatHandler.initText(message.comp_893());
            TranslateClickEvent event = ChatHandler.getTranslateClickEvent(text);
            if (event == null || event.clicked) continue;
            text.field_39006.removeLast();
            text.field_39006.removeLast();
        }
        ChatHandler.refresh();
    }

    public static void handleNewMessage(class_2561 text) {
        class_5250 initText = ChatHandler.initText(text);
        if (ChatOption.autoChat.isEnable()) {
            ChatHandler.translate(initText);
        }
        if (class_310.method_1551().field_1755 instanceof class_408) {
            ChatHandler.addTip(initText);
        }
    }

    public static void translate(class_5250 text) {
        String s = StringUtil.strip(text.getString());
        translatingTexts.add(text);
        CompletableFuture.supplyAsync(() -> {
            try {
                String result = TranslatorManager.cachedTranslate(s);
                return ChatHandler.createResultText(result, text);
            }
            catch (Exception e) {
                return ChatHandler.createErrorText(e.getMessage(), text, s);
            }
        }).thenAccept(result -> {
            translatingTexts.remove(text);
            TranslateClickEvent event = ChatHandler.getTranslateClickEvent(text);
            if (event != null) {
                text.field_39006.set(text.field_39006.size() - 1, result);
            } else {
                text.method_27693(" ").method_10852(result);
            }
            class_310.method_1551().execute(ChatHandler::refresh);
        });
    }

    public static void translateWithTip(class_5250 text) {
        if (translatingTexts.contains(text)) {
            return;
        }
        text.field_39006.removeLast();
        ChatHandler.translate(text);
        text.field_39006.add(TRANSLATING_TIP);
        ChatHandler.refresh();
    }

    private static class_2561 createErrorText(String err, class_5250 originalText, String original) {
        return class_2561.method_43470((String)("[" + err + "]")).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xCC2323)).method_10949(TRANSLATE_HOVER_EVENT).method_10958((class_2558)new TranslateClickEvent(originalText, true)).method_10975(original));
    }

    private static class_2561 createResultText(String result, class_5250 originalText) {
        return class_2561.method_43470((String)result).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0x2FFF2C)).method_10949(TRANSLATE_HOVER_EVENT).method_10958((class_2558)new TranslateClickEvent(originalText, true)).method_10975(result));
    }

    private static class_5250 initText(class_2561 text) {
        class_5250 t = (class_5250)text;
        if (!(t.field_39006 instanceof ArrayList)) {
            t.field_39006 = new ArrayList(t.field_39006);
        }
        return t;
    }

    @Nullable
    private static TranslateClickEvent getTranslateClickEvent(class_5250 text) {
        class_2558 class_25582;
        if (text.field_39006.size() >= 2 && (class_25582 = ((class_2561)text.field_39006.getLast()).method_10866().method_10970()) instanceof TranslateClickEvent) {
            TranslateClickEvent event = (TranslateClickEvent)class_25582;
            return event;
        }
        return null;
    }

    public static class TranslateClickEvent
    extends class_2558 {
        public class_5250 text;
        public boolean clicked;

        public TranslateClickEvent(class_5250 text, boolean clicked) {
            super(null, "");
            this.text = text;
            this.clicked = clicked;
        }

        public TranslateClickEvent(class_5250 text) {
            this(text, false);
        }
    }
}

