/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kgg.translator.TranslatorManager;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TranslateHelper {
    private static final Logger LOGGER = LogManager.getLogger(TranslateHelper.class);
    private static final ConcurrentHashMap<String, Long> failedTextCache = new ConcurrentHashMap();
    private static final ConcurrentLinkedQueue<String> translatingTexts = new ConcurrentLinkedQueue();
    private static final int MAX_FAILED_TEXT_CACHE_TIME = 120000;
    private static final long CHECK_TIME = 300000L;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();

    public static class_2561 translateNoWait(class_2561 text) {
        return TranslateHelper.translateNoWait(text, (String s) -> {});
    }

    public static class_2561 translateNoWait(class_2561 text, Consumer<String> comparable) {
        return class_2561.method_43470((String)TranslateHelper.translateNoWait(text.getString(), comparable)).method_27696(text.method_10866());
    }

    public static String translateNoWait(String text) {
        return TranslateHelper.translateNoWait(text, (String s) -> {});
    }

    public static String translateNoWait(String text, Consumer<String> comparable) {
        String cache;
        Long aLong = failedTextCache.get(text);
        if (aLong != null) {
            if (System.currentTimeMillis() - aLong > 120000L) {
                failedTextCache.remove(text);
            } else {
                return text;
            }
        }
        if ((cache = TranslatorManager.getFromCache(text)) != null) {
            return cache;
        }
        if (translatingTexts.contains(text)) {
            return text;
        }
        translatingTexts.add(text);
        CompletableFuture.runAsync(() -> {
            try {
                String s = TranslatorManager.cachedTranslate(text);
                comparable.accept(s);
            }
            catch (Exception e) {
                failedTextCache.put(text, System.currentTimeMillis());
            }
            finally {
                translatingTexts.remove(text);
            }
        });
        return text;
    }

    public static void clearCache() {
        LOGGER.info("Clear failed cache");
        failedTextCache.clear();
    }

    static {
        SCHEDULED_EXECUTOR.scheduleAtFixedRate(() -> failedTextCache.entrySet().removeIf(entry -> System.currentTimeMillis() - (Long)entry.getValue() > 120000L), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }
}

