/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator.translator;

import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kgg.translator.command.CommandConfigurable;
import kgg.translator.exception.ErrorCodeException;
import kgg.translator.exception.TranslateException;
import kgg.translator.ocrtrans.ResRegion;
import kgg.translator.translator.Translator;
import kgg.translator.util.EasyProperties;
import kgg.translator.util.RequestUtil;

public abstract class BaiduTranslator
extends Translator
implements CommandConfigurable {
    public static final String URL = "https://fanyi-api.baidu.com/api/trans/vip/translate";
    public static final String OCR_URL = "https://fanyi-api.baidu.com/api/trans/sdk/picture";
    private String appId;
    private String appKey;
    private int delayTime = 1000;
    public static final EasyProperties LANGUAGES;

    @Override
    public synchronized String translate(String text, String from, String to) throws IOException {
        return this.delay(this.delayTime, () -> {
            String salt = String.valueOf(System.currentTimeMillis());
            Map<String, Object> params = Map.of("q", text, "from", from, "to", to, "appid", this.appId, "salt", salt, "sign", Hashing.md5().hashString((CharSequence)(this.appId + text + salt + this.appKey), StandardCharsets.UTF_8).toString());
            String result = RequestUtil.get(URL, params);
            JsonObject object = (JsonObject)JsonParser.parseString((String)result);
            this.checkCode(object.get("error_code"));
            StringJoiner joiner = new StringJoiner(" ");
            for (JsonElement element : object.get("trans_result").getAsJsonArray()) {
                joiner.add(element.getAsJsonObject().get("dst").getAsString());
            }
            return joiner.toString();
        });
    }

    @Override
    public ResRegion[] ocrtrans(byte[] img, String from, String to) throws IOException {
        String salt = "123";
        String imgMd5 = Hashing.md5().hashBytes(img).toString();
        String sign = Hashing.md5().hashString((CharSequence)(this.appId + imgMd5 + salt + "APICUIDmac" + this.appKey), StandardCharsets.UTF_8).toString();
        Map<String, Object> params = Map.of("from", from, "to", to, "appid", this.appId, "salt", salt, "cuid", "APICUID", "mac", "mac", "version", 3, "sign", sign);
        String result = RequestUtil.fromData(OCR_URL, params, img, "image");
        JsonObject object = (JsonObject)JsonParser.parseString((String)result);
        this.checkCode(object.get("error_code"));
        return (ResRegion[])object.getAsJsonObject("data").getAsJsonArray("content").asList().stream().map(JsonElement::getAsJsonObject).map(c -> {
            String rect = c.get("rect").getAsString();
            List<Integer> list = Arrays.stream(rect.split(" ")).map(Integer::parseInt).toList();
            return new ResRegion(list.get(0), list.get(1), list.get(2), list.get(3), c.get("dst").getAsString(), c.get("src").getAsString());
        }).toArray(ResRegion[]::new);
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    private void checkCode(JsonElement code) throws TranslateException {
        if (code != null && code.getAsInt() != 0) {
            throw new ErrorCodeException("baidu", code.getAsString());
        }
    }

    @Override
    public String getName() {
        return "\u767e\u5ea6\u7ffb\u8bd1";
    }

    public void setConfig(String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
        this.setConfigured();
    }

    @Override
    public void read(JsonObject object) {
        this.setConfig(object.get("appId").getAsString(), object.get("appKey").getAsString());
        this.setDelayTime(object.get("delayTime").getAsInt());
    }

    @Override
    public void write(JsonObject object) {
        object.addProperty("appId", this.appId);
        object.addProperty("appKey", this.appKey);
        object.addProperty("delayTime", (Number)this.delayTime);
    }

    @Override
    public EasyProperties getLanguageProperties() {
        return LANGUAGES;
    }

    static {
        try {
            LANGUAGES = new EasyProperties(BaiduTranslator.class.getClassLoader().getResourceAsStream("languages/baidu.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

