/*
 * Decompiled with CFR 0.152.
 */
package kgg.translator.translator;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kgg.translator.command.CommandConfigurable;
import kgg.translator.exception.TranslateException;
import kgg.translator.ocrtrans.ResRegion;
import kgg.translator.util.EasyProperties;

public abstract class Translator
implements CommandConfigurable {
    private boolean configured = false;
    private long startTime = 0L;
    private final Lock lock = new ReentrantLock();

    public abstract String translate(String var1, String var2, String var3) throws IOException;

    public ResRegion[] ocrtrans(byte[] img, String from, String to) throws IOException {
        throw new TranslateException(this.getName() + "\u4e0d\u652f\u6301\u56fe\u7247\u7ffb\u8bd1");
    }

    public abstract String getName();

    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured() {
        this.setConfigured(true);
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public EasyProperties getLanguageProperties() {
        return null;
    }

    public abstract void read(JsonObject var1);

    public abstract void write(JsonObject var1);

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T delay(long time, ThrowingSupplier<T> runnable) throws IOException {
        this.lock.lock();
        if (System.currentTimeMillis() - this.startTime < time) {
            try {
                TimeUnit.MILLISECONDS.sleep(time - (System.currentTimeMillis() - this.startTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            T t = runnable.get();
            return t;
        }
        finally {
            this.startTime = System.currentTimeMillis();
            this.lock.unlock();
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws IOException;
    }
}

