/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.jei;

import com.hqbdh.hqbdh_mod.jei.StackUtils;
import com.hqbdh.hqbdh_mod.recipe.MixCutRecipe;
import com.hqbdh.hqbdh_mod.registry.ModBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class MixingCuttingRecipeCategory
implements IRecipeCategory<MixCutRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("mixing_cutting", "mixing_cutting");
    public static final RecipeType<MixCutRecipe> RECIPE_TYPE = RecipeType.create((String)"mixing_cutting", (String)"mixing_cutting", MixCutRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;
    private final IDrawableStatic slotBackground;
    ResourceLocation slotTexture = new ResourceLocation("mixing_cutting", "textures/gui/container/thing_design.png");
    private static final ResourceLocation PROCESS_TEXTURE = new ResourceLocation("mixing_cutting", "textures/gui/container/process_mix_cut.png");
    private static final ResourceLocation PROCESS_TEXTURE_flag = new ResourceLocation("mixing_cutting", "textures/gui/container/flag_process_mix_cut.png");

    public MixingCuttingRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        ResourceLocation guiTexture = new ResourceLocation("mixing_cutting", "textures/gui/container/mix_gui_jei.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 0, 176, 178);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.MIX_CUT_TABLE.get()));
        this.slotBackground = guiHelper.createDrawable(this.slotTexture, 0, 0, 18, 18);
    }

    public RecipeType<MixCutRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.mixing_cutting.mix_cut_table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MixCutRecipe recipe, IFocusGroup focuses) {
        int inputX = 8;
        int inputY = 18;
        NonNullList<MixCutRecipe.CountedIngredient> countedIngredients = recipe.getCountedIngredients();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                MixCutRecipe.CountedIngredient ci;
                int slotIndex = row * 3 + col;
                int slotX = inputX + col * 18;
                int slotY = inputY + row * 18;
                if (slotIndex >= countedIngredients.size() || (ci = (MixCutRecipe.CountedIngredient)countedIngredients.get(slotIndex)) == null || ci.ingredient.m_43947_()) continue;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addItemStacks(StackUtils.expandWithCount(ci.ingredient, ci.count))).setBackground((IDrawable)this.slotBackground, -1, -1);
            }
        }
        int outputX = 147;
        int outputY = 54;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, outputX, outputY).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()))).setBackground((IDrawable)this.slotBackground, -1, -1);
        int fluidX = 65;
        int fluidY = 20;
        FluidStack fluidRequirement = recipe.getFluidRequirement();
        if (!fluidRequirement.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, fluidX, fluidY).addFluidStack(fluidRequirement.getFluid(), (long)fluidRequirement.getAmount())).setFluidRenderer((long)fluidRequirement.getAmount(), false, 7, 54);
        }
    }

    public void draw(MixCutRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int processX = 8;
        int processY = 82;
        boolean u = false;
        boolean v = false;
        int width = 67;
        int height = 65;
        int textureWidth = 70;
        int textureHeight = 70;
        guiGraphics.m_280163_(PROCESS_TEXTURE, processX, processY, (float)u, (float)v, width, height, textureWidth, textureHeight);
        boolean u_flag = false;
        boolean v_flag = false;
        int width_flag = 91;
        int height_flag = 39;
        int textureWidth_flag = 920;
        int textureHeight_flag = 705;
        int processX_flag = processX + width - 2;
        int processY_flag = processY;
        guiGraphics.m_280163_(PROCESS_TEXTURE_flag, processX_flag, processY_flag, (float)u_flag, (float)v_flag, width_flag, height_flag, textureWidth_flag, textureHeight_flag);
    }
}

