/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.menu;

import com.hqbdh.hqbdh_mod.block.entity.MixCutTableBlockEntity;
import com.hqbdh.hqbdh_mod.recipe.MixCutRecipe;
import com.hqbdh.hqbdh_mod.registry.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MixCutTableMenu
extends AbstractContainerMenu {
    private final MixCutTableBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private static final int INPUT_SLOT_START_X = 8;
    private static final int INPUT_SLOT_START_Y = 18;
    private static final int OUTPUT_SLOT_X = 141;
    private static final int OUTPUT_SLOT_Y = 30;
    private static final int PLAYER_INV_START_X = 8;
    private static final int PLAYER_INV_START_Y = 84;
    private static final int HOTBAR_START_Y = 142;
    private static final int RESULT_SLOT_X = 75;
    private static final int RESULT_SLOT_Y = 19;
    private static final int RECIPE_DISPLAY_SLOT_X = 82;
    private static final int RECIPE_DISPLAY_SLOT_Y = 20;
    private ContainerData data;

    public MixCutTableMenu(int windowId, Inventory playerInventory, MixCutTableBlockEntity entity, BlockPos pos) {
        super((MenuType)ModMenus.MIX_CUT_TABLE.get(), windowId);
        this.blockEntity = entity;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)entity.m_58904_(), (BlockPos)pos);
        this.data = entity.getContainerData();
        if (entity != null) {
            IItemHandler entityInventory = entity.getItemHandler();
            this.registerSlots(entityInventory, playerInventory);
            this.m_38884_(this.data);
        } else {
            this.data = new SimpleContainerData(4);
            this.m_38884_(this.data);
        }
    }

    public MixCutTableMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        super((MenuType)ModMenus.MIX_CUT_TABLE.get(), windowId);
        MixCutTableBlockEntity entity;
        BlockPos pos = buf.m_130135_();
        this.blockEntity = entity = MixCutTableMenu.getBlockEntityFromBuf(playerInventory, pos);
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)pos);
        if (entity != null) {
            IItemHandler entityInventory = entity.getItemHandler();
            this.registerSlots(entityInventory, playerInventory);
            CompoundTag fluidTag = buf.m_130260_();
            if (fluidTag != null && fluidTag.m_128441_("MixCutTable_FluidTank")) {
                CompoundTag fluidTankTag = fluidTag.m_128469_("MixCutTable_FluidTank");
                entity.getFluidTank().readFromNBT(fluidTankTag);
            }
            this.data = entity.getContainerData();
            this.m_38884_(this.data);
        } else {
            this.data = new SimpleContainerData(4);
            this.m_38884_(this.data);
            System.out.println("[\u5ba2\u6237\u7aef\u83dc\u5355] \u8b66\u544a\uff1a\u65b9\u5757\u5b9e\u4f53\u4e3anull\uff08\u4f4d\u7f6e\uff1a" + pos + "\uff09");
        }
    }

    private void registerSlots(final IItemHandler entityInventory, Inventory playerInventory) {
        int y;
        int x;
        int slotIndex;
        int col;
        int row;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                slotIndex = row * 3 + col;
                x = 9 + col * 18;
                y = 19 + row * 18;
                this.m_38897_((Slot)new SlotItemHandler(entityInventory, slotIndex, x, y));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler(entityInventory, 9, 147, 54){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public ItemStack m_7993_() {
                return entityInventory.getStackInSlot(9);
            }

            public void selectRecipeClientSide(String recipeId) {
            }

            public boolean m_6657_() {
                return !this.m_7993_().m_41619_();
            }

            public ItemStack m_6201_(int amount) {
                return entityInventory.extractItem(9, amount, false);
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                if (MixCutTableMenu.this.blockEntity != null && !player.m_9236_().m_5776_()) {
                    MixCutTableMenu.this.blockEntity.craftSelectedRecipe();
                }
            }

            public boolean m_8010_(Player player) {
                return !this.m_7993_().m_41619_();
            }
        });
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                slotIndex = 10 + row * 3 + col;
                x = 75 + col * 18;
                y = 19 + row * 18;
                this.m_38897_((Slot)new SlotItemHandler(entityInventory, slotIndex, x, y){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                slotIndex = col + row * 9 + 9;
                x = 9 + col * 18;
                y = 85 + row * 18;
                this.m_38897_(new Slot((Container)playerInventory, slotIndex, x, y));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            int slotIndex2 = col2;
            int x2 = 9 + col2 * 18;
            int y2 = 143;
            this.m_38897_(new Slot((Container)playerInventory, slotIndex2, x2, y2));
        }
    }

    private static MixCutTableBlockEntity getBlockEntityFromBuf(Inventory playerInventory, BlockPos pos) {
        Level level = playerInventory.f_35978_.m_9236_();
        BlockEntity rawEntity = level.m_7702_(pos);
        return rawEntity instanceof MixCutTableBlockEntity ? (MixCutTableBlockEntity)rawEntity : null;
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.levelAccess.m_39299_((level, pos) -> {
            BlockEntity currentEntity = level.m_7702_(pos);
            boolean isEntityValid = currentEntity instanceof MixCutTableBlockEntity;
            boolean isDistanceValid = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
            return isEntityValid && isDistanceValid;
        }, (Object)false);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 9) {
                if (!this.m_38903_(itemstack1, 27, 55, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 10 && index <= 18) {
                int recipeSlotIndex = index - 10;
                int actualRecipeIndex = this.blockEntity.getScrollOffset() + recipeSlotIndex;
                if (this.blockEntity != null && actualRecipeIndex < this.blockEntity.getAvailableRecipes().size()) {
                    MixCutRecipe selectedRecipe = this.blockEntity.getAvailableRecipes().get(actualRecipeIndex);
                    this.blockEntity.selectRecipe(selectedRecipe.getRecipeId());
                }
                if (!this.m_38903_(itemstack1, 27, 63, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 27 && index < 55 && !this.m_38903_(itemstack1, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public MixCutTableBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ContainerLevelAccess getLevelAccess() {
        return this.levelAccess;
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.data.m_6413_(1);
    }

    public int getScrollOffset() {
        return this.data.m_6413_(2);
    }

    public int getAvailableRecipeCount() {
        return this.data.m_6413_(3);
    }

    public void setScrollOffset(int offset) {
        if (this.blockEntity != null) {
            this.blockEntity.setScrollOffset(offset);
        }
    }

    public void selectRecipe(String recipeId) {
        if (this.blockEntity != null) {
            this.blockEntity.selectRecipe(recipeId);
        }
    }

    public void craftRecipe() {
        if (this.blockEntity != null) {
            this.blockEntity.craftSelectedRecipe();
        }
    }

    public void selectRecipeClientSide(String recipeId) {
        if (this.blockEntity != null) {
            this.blockEntity.selectRecipe(recipeId);
        }
    }
}

