/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hqbdh.hqbdh_mod.recipe.ModRecipes;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class MixCutRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<CountedIngredient> ingredients;
    private final FluidStack fluidRequirement;
    private final int processTime;
    private final String recipeId;
    private final int resultCount;
    private final ItemStack itemResult;
    private final TagKey<Item> tagResult;

    public MixCutRecipe(ResourceLocation id, NonNullList<CountedIngredient> ingredients, FluidStack fluidRequirement, ItemStack itemResult, TagKey<Item> tagResult, int resultCount, int processTime, String recipeId) {
        this.id = id;
        this.ingredients = ingredients;
        this.fluidRequirement = fluidRequirement;
        this.itemResult = itemResult == null || itemResult.m_41619_() ? null : itemResult;
        this.tagResult = tagResult;
        this.resultCount = resultCount;
        this.processTime = processTime;
        this.recipeId = recipeId;
    }

    public boolean m_5818_(Container container, Level level) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.itemResult != null ? this.itemResult.m_41777_() : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.itemResult != null ? this.itemResult.m_41777_() : ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.MIX_CUT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.MIX_CUT_TYPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList flattenedIngredients = NonNullList.m_122779_();
        for (CountedIngredient ci : this.ingredients) {
            flattenedIngredients.add((Object)ci.ingredient);
        }
        return flattenedIngredients;
    }

    public NonNullList<CountedIngredient> getCountedIngredients() {
        return this.ingredients;
    }

    public FluidStack getFluidRequirement() {
        return this.fluidRequirement.copy();
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public String getRecipeId() {
        return this.recipeId;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public boolean hasTagResult() {
        return this.tagResult != null;
    }

    public TagKey<Item> getTagResult() {
        return this.tagResult;
    }

    public boolean matchesInput(NonNullList<ItemStack> inputItems, FluidStack availableFluid) {
        if (!this.fluidRequirement.isEmpty() ? availableFluid.isEmpty() || !availableFluid.isFluidEqual(this.fluidRequirement) || availableFluid.getAmount() < this.fluidRequirement.getAmount() : !availableFluid.isEmpty()) {
            return false;
        }
        for (ItemStack inputStack : inputItems) {
            if (inputStack.m_41619_()) continue;
            boolean isRequiredSpecies = false;
            for (CountedIngredient requirement : this.getCountedIngredients()) {
                if (!requirement.ingredient.test(inputStack)) continue;
                isRequiredSpecies = true;
                break;
            }
            if (isRequiredSpecies) continue;
            return false;
        }
        for (CountedIngredient requirement : this.getCountedIngredients()) {
            int needed = requirement.count;
            int found = 0;
            for (ItemStack inputStack : inputItems) {
                if (!requirement.ingredient.test(inputStack)) continue;
                found += inputStack.m_41613_();
            }
            if (found >= needed) continue;
            return false;
        }
        return true;
    }

    public static class CountedIngredient {
        public final Ingredient ingredient;
        public final int count;

        public CountedIngredient(Ingredient ingredient, int count) {
            this.ingredient = ingredient;
            this.count = Math.max(1, count);
        }
    }

    public static class Serializer
    implements RecipeSerializer<MixCutRecipe> {
        public MixCutRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<CountedIngredient> ingredients = this.readCountedIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            FluidStack fluidStack = FluidStack.EMPTY;
            if (json.has("fluid")) {
                JsonObject fluidJson = GsonHelper.m_13930_((JsonObject)json, (String)"fluid");
                String fluidId = GsonHelper.m_13906_((JsonObject)fluidJson, (String)"fluid");
                int amount = GsonHelper.m_13824_((JsonObject)fluidJson, (String)"amount", (int)100);
                fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidId)), amount);
            }
            JsonObject resultJson = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack resultStack = null;
            TagKey resultTag = null;
            int resultCount = 1;
            if (resultJson.has("item")) {
                resultStack = ShapedRecipe.m_151274_((JsonObject)resultJson);
                if (resultJson.has("nbt")) {
                    try {
                        String nbtString = resultJson.get("nbt").getAsString();
                        CompoundTag nbt = TagParser.m_129359_((String)nbtString);
                        resultStack.m_41751_(nbt);
                    }
                    catch (CommandSyntaxException e) {
                        throw new JsonParseException("Invalid NBT format for result item", (Throwable)e);
                    }
                }
            } else if (resultJson.has("tag")) {
                String tagString = GsonHelper.m_13906_((JsonObject)resultJson, (String)"tag");
                resultTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagString));
                resultCount = GsonHelper.m_13824_((JsonObject)resultJson, (String)"count", (int)1);
            } else {
                throw new JsonParseException("Recipe result must have either an 'item' or a 'tag'");
            }
            int processTime = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            String customRecipeId = GsonHelper.m_13851_((JsonObject)json, (String)"recipe_id", (String)recipeId.toString());
            return new MixCutRecipe(recipeId, ingredients, fluidStack, resultStack, (TagKey<Item>)resultTag, resultCount, processTime, customRecipeId);
        }

        private NonNullList<CountedIngredient> readCountedIngredients(JsonArray ingredientArray) {
            NonNullList countedIngredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                JsonObject ingredientJson = ingredientArray.get(i).getAsJsonObject();
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
                int count = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"count", (int)1);
                if (ingredient.m_43947_()) continue;
                countedIngredients.add((Object)new CountedIngredient(ingredient, count));
            }
            return countedIngredients;
        }

        @Nullable
        public MixCutRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, null);
            for (int i = 0; i < ingredientCount; ++i) {
                Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int count = buffer.m_130242_();
                ingredients.set(i, (Object)new CountedIngredient(ing, count));
            }
            FluidStack fluidStack = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack resultStack = null;
            TagKey resultTag = null;
            boolean isTag = buffer.readBoolean();
            if (isTag) {
                resultTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buffer.m_130281_());
            } else {
                resultStack = buffer.m_130267_();
                if (resultStack.m_41619_()) {
                    resultStack = null;
                }
            }
            int resultCount = buffer.m_130242_();
            int processTime = buffer.m_130242_();
            String customRecipeId = buffer.m_130277_();
            return new MixCutRecipe(recipeId, (NonNullList<CountedIngredient>)ingredients, fluidStack, resultStack, (TagKey<Item>)resultTag, resultCount, processTime, customRecipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, MixCutRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (CountedIngredient ci : recipe.ingredients) {
                ci.ingredient.m_43923_(buffer);
                buffer.m_130130_(ci.count);
            }
            recipe.fluidRequirement.writeToPacket(buffer);
            boolean isTag = recipe.hasTagResult();
            buffer.writeBoolean(isTag);
            if (isTag) {
                buffer.m_130085_(recipe.getTagResult().f_203868_());
            } else {
                buffer.m_130055_(recipe.itemResult != null ? recipe.itemResult : ItemStack.f_41583_);
            }
            buffer.m_130130_(recipe.resultCount);
            buffer.m_130130_(recipe.processTime);
            buffer.m_130070_(recipe.recipeId);
        }
    }
}

