/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidBucketSupport {
    private static final Map<ResourceLocation, Item> FLUID_TO_BUCKET = new HashMap<ResourceLocation, Item>();

    public static void init() {
        FluidBucketSupport.addSupport((Fluid)Fluids.f_76193_, Items.f_42447_);
        FluidBucketSupport.addSupport((Fluid)Fluids.f_76195_, Items.f_42448_);
        FluidBucketSupport.addSupport("alexscaves:acid", "alexscaves:acid_bucket");
    }

    private static void addSupport(Fluid fluid, Item bucketItem) {
        ResourceLocation fluidRL = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        if (fluidRL != null) {
            FLUID_TO_BUCKET.put(fluidRL, bucketItem);
        }
    }

    private static void addSupport(String fluidRLStr, String bucketRLStr) {
        Item bucket;
        ResourceLocation fluidRL = new ResourceLocation(fluidRLStr);
        ResourceLocation bucketRL = new ResourceLocation(bucketRLStr);
        if (ForgeRegistries.ITEMS.containsKey(bucketRL) && (bucket = (Item)ForgeRegistries.ITEMS.getValue(bucketRL)) != null) {
            FLUID_TO_BUCKET.put(fluidRL, bucket);
        }
    }

    public static boolean isSupportedFluidBucket(ItemStack stack) {
        if (stack.m_41720_() instanceof BucketItem) {
            ResourceLocation bucketRL = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            return FLUID_TO_BUCKET.containsValue(stack.m_41720_()) || bucketRL != null && FLUID_TO_BUCKET.entrySet().stream().anyMatch(e -> ForgeRegistries.ITEMS.getKey((Object)((Item)e.getValue())).equals((Object)bucketRL));
        }
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public static FluidStack getFluidFromBucket(ItemStack stack) {
        if (stack.m_150930_(Items.f_42447_)) {
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }
        if (stack.m_150930_(Items.f_42448_)) {
            return new FluidStack((Fluid)Fluids.f_76195_, 1000);
        }
        ResourceLocation stackRL = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (stackRL != null && stackRL.equals((Object)new ResourceLocation("alexscaves:acid_bucket"))) {
            Fluid acid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("alexscaves:acid"));
            return acid != null ? new FluidStack(acid, 1000) : FluidStack.EMPTY;
        }
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> handler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }

    public static boolean isSupportedFluid(Fluid fluid) {
        return true;
    }

    public static boolean isSupportedFluidHandler(IFluidHandler handler) {
        return true;
    }

    public static ItemStack createFilledBucket(Fluid fluid) {
        ResourceLocation fluidRL = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        if (fluidRL != null && FLUID_TO_BUCKET.containsKey(fluidRL)) {
            return new ItemStack((ItemLike)FLUID_TO_BUCKET.get(fluidRL));
        }
        ItemStack emptyBucket = new ItemStack((ItemLike)Items.f_42446_);
        return emptyBucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
            FluidStack fluidToFill = new FluidStack(fluid, 1000);
            if (handler.fill(fluidToFill, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                handler.fill(fluidToFill, IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer();
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }
}

