/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.block;

import com.hqbdh.hqbdh_mod.block.entity.MixCutTableBlockEntity;
import com.hqbdh.hqbdh_mod.util.FluidBucketSupport;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MixCutTableBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.5, (double)15.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)15.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83110_((VoxelShape)v1, (VoxelShape)v2)).get();

    public MixCutTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(1.0f, 6.0f).m_60918_(SoundType.f_56742_).m_60955_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MixCutTableBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            int fluidAmount;
            FluidStack fluid;
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.PASS;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity entity = level.m_7702_(pos);
            if (!(entity instanceof MixCutTableBlockEntity)) {
                return InteractionResult.PASS;
            }
            MixCutTableBlockEntity mixCutEntity = (MixCutTableBlockEntity)entity;
            mixCutEntity.updateAvailableRecipes();
            mixCutEntity.m_6596_();
            level.m_7260_(pos, state, state, 3);
            ItemStack heldStack = player.m_21120_(hand);
            if (heldStack.m_41720_() instanceof BucketItem && FluidBucketSupport.isSupportedFluidBucket(heldStack) && !(fluid = FluidBucketSupport.getFluidFromBucket(heldStack)).isEmpty()) {
                mixCutEntity.getFluidTank().setFluid(new FluidStack(fluid.getFluid(), mixCutEntity.getFluidTank().getCapacity()));
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
            if (heldStack.m_150930_(Items.f_42446_) && (fluidAmount = mixCutEntity.getFluidTank().getFluidAmount()) > 0) {
                FluidStack tankFluid = mixCutEntity.getFluidTank().getFluid();
                if (fluidAmount >= 500) {
                    ItemStack filledBucket = FluidBucketSupport.createFilledBucket(tankFluid.getFluid());
                    if (!filledBucket.m_41619_()) {
                        mixCutEntity.getFluidTank().drain(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                        if (!player.m_7500_()) {
                            heldStack.m_41774_(1);
                            if (heldStack.m_41619_()) {
                                player.m_21008_(hand, filledBucket);
                            } else if (!player.m_150109_().m_36054_(filledBucket)) {
                                player.m_36176_(filledBucket, false);
                            }
                        }
                        level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    mixCutEntity.getFluidTank().drain(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                }
                return InteractionResult.CONSUME;
            }
            heldStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> {
                FluidStack toFill;
                int filled;
                int amount;
                FluidStack tankFluid;
                FluidStack bucketFluid = fluidHandler.getFluidInTank(0);
                if (!bucketFluid.isEmpty() && FluidBucketSupport.isSupportedFluid(bucketFluid.getFluid())) {
                    int filled2 = mixCutEntity.getFluidTank().fill(bucketFluid, IFluidHandler.FluidAction.EXECUTE);
                    if (filled2 > 0) {
                        fluidHandler.drain(filled2, IFluidHandler.FluidAction.EXECUTE);
                        level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        player.m_21008_(hand, fluidHandler.getContainer());
                    }
                } else if (bucketFluid.isEmpty() && FluidBucketSupport.isSupportedFluidHandler((IFluidHandler)fluidHandler) && !(tankFluid = mixCutEntity.getFluidTank().getFluid()).isEmpty() && FluidBucketSupport.isSupportedFluid(tankFluid.getFluid()) && (amount = mixCutEntity.getFluidTank().getFluidAmount()) >= 500 && (filled = fluidHandler.fill(toFill = new FluidStack(tankFluid.getFluid(), 500), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    mixCutEntity.getFluidTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21008_(hand, fluidHandler.getContainer());
                }
            });
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)mixCutEntity, buf -> {
                buf.m_130064_(pos);
                CompoundTag fluidTag = new CompoundTag();
                CompoundTag fluidTankTag = new CompoundTag();
                mixCutEntity.getFluidTank().writeToNBT(fluidTankTag);
                fluidTag.m_128365_("MixCutTable_FluidTank", (Tag)fluidTankTag);
                buf.m_130079_(fluidTag);
            });
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }
}

