/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.block.entity;

import com.hqbdh.hqbdh_mod.menu.MixCutTableMenu;
import com.hqbdh.hqbdh_mod.recipe.MixCutRecipe;
import com.hqbdh.hqbdh_mod.recipe.ModRecipes;
import com.hqbdh.hqbdh_mod.registry.ModBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MixCutTableBlockEntity
extends BlockEntity
implements MenuProvider {
    private boolean isUpdatingResults = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(19){

        protected void onContentsChanged(int slot) {
            MixCutTableBlockEntity.this.m_6596_();
            if (MixCutTableBlockEntity.this.f_58857_ != null) {
                MixCutTableBlockEntity.this.f_58857_.m_7260_(MixCutTableBlockEntity.this.m_58899_(), MixCutTableBlockEntity.this.m_58900_(), MixCutTableBlockEntity.this.m_58900_(), 3);
            }
            if (!MixCutTableBlockEntity.this.isUpdatingResults && slot < 9) {
                MixCutTableBlockEntity.this.updateAvailableRecipes();
            }
        }
    };
    private final FluidTank fluidTank = new FluidTank(1000){

        protected void onContentsChanged() {
            MixCutTableBlockEntity.this.m_6596_();
            if (MixCutTableBlockEntity.this.f_58857_ != null) {
                MixCutTableBlockEntity.this.f_58857_.m_7260_(MixCutTableBlockEntity.this.m_58899_(), MixCutTableBlockEntity.this.m_58900_(), MixCutTableBlockEntity.this.m_58900_(), 3);
            }
            if (!MixCutTableBlockEntity.this.isUpdatingResults) {
                MixCutTableBlockEntity.this.updateAvailableRecipes();
            }
        }
    };
    private int progress = 0;
    private int maxProgress = 200;
    private String selectedRecipeId = "";
    private final List<MixCutRecipe> availableRecipes = new ArrayList<MixCutRecipe>();
    private int scrollOffset = 0;
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MixCutTableBlockEntity.this.progress;
                case 1 -> MixCutTableBlockEntity.this.maxProgress;
                case 2 -> MixCutTableBlockEntity.this.scrollOffset;
                case 3 -> MixCutTableBlockEntity.this.availableRecipes.size();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MixCutTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MixCutTableBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    MixCutTableBlockEntity.this.scrollOffset = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("fluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
        if (tag.m_128441_("fluidTank")) {
            this.fluidTank.readFromNBT(tag.m_128469_("fluidTank"));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public MixCutTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MIX_CUT_TABLE.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.mixing_cutting.mix_cut_table");
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new MixCutTableMenu(windowId, inventory, this, this.m_58899_());
    }

    public void updateAvailableRecipes() {
        if (this.f_58857_ == null) {
            return;
        }
        this.availableRecipes.clear();
        NonNullList inputItems = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 9; ++i) {
            inputItems.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        FluidStack currentFluid = this.fluidTank.getFluid();
        List allRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.MIX_CUT_TYPE.get());
        for (MixCutRecipe recipe : allRecipes) {
            if (!recipe.matchesInput((NonNullList<ItemStack>)inputItems, currentFluid)) continue;
            this.availableRecipes.add(recipe);
        }
        this.m_6596_();
        this.updateResultSlot();
    }

    public void selectRecipe(String recipeId) {
        this.selectedRecipeId = recipeId;
        this.updateResultSlot();
        this.m_6596_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateAvailableRecipes();
        }
    }

    private void updateResultSlot() {
        if (this.f_58857_ == null) {
            return;
        }
        this.isUpdatingResults = true;
        try {
            for (int i = 10; i <= 18; ++i) {
                this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
            }
            if (this.selectedRecipeId.isEmpty()) {
                this.itemHandler.setStackInSlot(9, ItemStack.f_41583_);
            }
            if (!this.selectedRecipeId.isEmpty()) {
                Optional<MixCutRecipe> selectedRecipe = this.availableRecipes.stream().filter(recipe -> recipe.getRecipeId().equals(this.selectedRecipeId)).findFirst();
                if (selectedRecipe.isPresent()) {
                    ItemStack result = selectedRecipe.get().m_8043_(this.f_58857_.m_9598_());
                    this.itemHandler.setStackInSlot(9, result.m_41777_());
                } else {
                    this.selectedRecipeId = "";
                    this.itemHandler.setStackInSlot(9, ItemStack.f_41583_);
                }
            }
        }
        finally {
            this.isUpdatingResults = false;
        }
    }

    public void craftSelectedRecipe() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.selectedRecipeId.isEmpty()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        Optional<MixCutRecipe> recipeOpt = this.availableRecipes.stream().filter(recipe -> recipe.getRecipeId().equals(this.selectedRecipeId)).findFirst();
        if (recipeOpt.isPresent()) {
            MixCutRecipe recipe2 = recipeOpt.get();
            NonNullList inputItems = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            for (int i = 0; i < 9; ++i) {
                inputItems.set(i, (Object)this.itemHandler.getStackInSlot(i));
            }
            FluidStack currentFluid = this.fluidTank.getFluid();
            if (recipe2.matchesInput((NonNullList<ItemStack>)inputItems, currentFluid)) {
                int newCount;
                ItemStack result = recipe2.m_8043_(this.f_58857_.m_9598_()).m_41777_();
                ItemStack outputSlot = this.itemHandler.getStackInSlot(9);
                boolean canOutput = false;
                if (outputSlot.m_41619_()) {
                    canOutput = true;
                } else if (ItemStack.m_150942_((ItemStack)outputSlot, (ItemStack)result) && (newCount = outputSlot.m_41613_() + result.m_41613_()) <= outputSlot.m_41741_()) {
                    canOutput = true;
                }
                if (!canOutput) {
                    return;
                }
                this.consumeInputItems(recipe2);
                if (!recipe2.getFluidRequirement().isEmpty()) {
                    this.fluidTank.drain(recipe2.getFluidRequirement().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
                if (outputSlot.m_41619_()) {
                    this.itemHandler.setStackInSlot(9, result);
                } else {
                    outputSlot.m_41769_(result.m_41613_());
                    this.itemHandler.setStackInSlot(9, outputSlot);
                }
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_6596_();
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                }
                this.updateAvailableRecipes();
            }
        }
    }

    private void consumeInputItems(MixCutRecipe recipe) {
        for (MixCutRecipe.CountedIngredient countedIngredient : recipe.getCountedIngredients()) {
            int needed = countedIngredient.count;
            for (int i = 0; i < 9; ++i) {
                ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
                if (!countedIngredient.ingredient.test(stackInSlot) || needed <= 0) continue;
                int toExtract = Math.min(stackInSlot.m_41613_(), needed);
                this.itemHandler.extractItem(i, toExtract, false);
                needed -= toExtract;
            }
        }
    }

    public List<MixCutRecipe> getAvailableRecipes() {
        return new ArrayList<MixCutRecipe>(this.availableRecipes);
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int offset) {
        this.scrollOffset = Math.max(0, offset);
        this.m_6596_();
    }

    public String getSelectedRecipeId() {
        return this.selectedRecipeId;
    }

    public ContainerData getContainerData() {
        return this.data;
    }
}

