/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.networking;

import com.hqbdh.hqbdh_mod.block.entity.MixCutTableBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SelectRecipePacket {
    private final BlockPos blockPos;
    private final String recipeId;

    public SelectRecipePacket(BlockPos blockPos, String recipeId) {
        this.blockPos = blockPos;
        this.recipeId = recipeId;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.m_130070_(this.recipeId);
    }

    public SelectRecipePacket(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.recipeId = buf.m_130277_();
    }

    public static void handle(SelectRecipePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity blockEntity = level.m_7702_(packet.blockPos);
            if (blockEntity instanceof MixCutTableBlockEntity) {
                MixCutTableBlockEntity mixEntity = (MixCutTableBlockEntity)blockEntity;
                mixEntity.selectRecipe(packet.recipeId);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

