/*
 * Decompiled with CFR 0.152.
 */
package com.hqbdh.hqbdh_mod.screen;

import com.hqbdh.hqbdh_mod.menu.MixCutTableMenu;
import com.hqbdh.hqbdh_mod.networking.Networking;
import com.hqbdh.hqbdh_mod.networking.SelectRecipePacket;
import com.hqbdh.hqbdh_mod.recipe.MixCutRecipe;
import com.hqbdh.hqbdh_mod.registry.FluidColorRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MixCutTableScreen
extends AbstractContainerScreen<MixCutTableMenu> {
    private static final int DEBUG_BORDER_COLOR_RED = -65536;
    private static final int DEBUG_BORDER_COLOR_GREEN = -16711936;
    private static final int DEBUG_BORDER_COLOR_YELLOW = -256;
    private static final int DEBUG_BORDER_COLOR_PURPLE = -65281;
    private static final int DEBUG_BORDER_COLOR_CYAN = -16711681;
    private static final ResourceLocation TEXTURE = new ResourceLocation("mixing_cutting:textures/gui/container/mix_gui.png");
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("mixing_cutting:textures/gui/mix_cut_table.png");
    private static final ResourceLocation SLIDER_TEXTURE = new ResourceLocation("mixing_cutting:textures/gui/container/slider.png");
    private static final ResourceLocation FLUID_OVERLAY = new ResourceLocation("mixing_cutting:textures/gui/fluid_overlay.png");
    private static final ResourceLocation INPUT_SLOT_TEXTURE = new ResourceLocation("mixing_cutting:textures/gui/container/thing_design.png");
    private static final ResourceLocation PLAYER_BACKPACK_TEXTURE = new ResourceLocation("mixing_cutting:textures/gui/container/thing_design.png");
    private static final ResourceLocation HOTBAR_TEXTURE = new ResourceLocation("mixing_cutting:textures/gui/container/thing_design.png");
    private int fluidTankX;
    private int fluidTankY;
    private int fluidTankWidth;
    private int fluidTankHeight;
    private static final ResourceLocation PLAYER_BACKPACK_TEXTURE_1 = new ResourceLocation("mixing_cutting:textures/gui/container/recipes_design.png");
    private int recipeDisplayCount = 9;
    private boolean isDraggingSlider = false;
    private static final int SLIDER_AREA_OFFSET_X = 135;
    private static final int SLIDER_AREA_OFFSET_Y = 20;
    private static final int SLIDER_TOTAL_HEIGHT = 54;
    private static final int SLIDER_HANDLE_HEIGHT = 10;
    private static final int SLIDER_HANDLE_WIDTH = 16;
    private static final int SLIDER_STP_X = 132;
    private static final int SLIDER_STP_Y = 132;

    public MixCutTableScreen(MixCutTableMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 186;
        this.f_97727_ = 166;
        this.fluidTankWidth = 7;
        this.fluidTankHeight = 54;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)INPUT_SLOT_TEXTURE);
        int inputSlotStartX = x + 8;
        int inputSlotStartY = y + 18;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotX = inputSlotStartX + col * 18;
                int slotY = inputSlotStartY + row * 18;
                guiGraphics.m_280218_(INPUT_SLOT_TEXTURE, slotX, slotY, 0, 0, 18, 18);
            }
        }
        this.fluidTankX = x + 65;
        this.fluidTankY = y + 20;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PLAYER_BACKPACK_TEXTURE);
        int playerBackpackStartX = x + 26 - 18;
        int playerBackpackStartY = y + 84;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotX = playerBackpackStartX + col * 18;
                int slotY = playerBackpackStartY + row * 18;
                int borderColor = -16777216;
                int borderColor_1 = -10066330;
                int borderColor_2 = -1;
                guiGraphics.m_280218_(PLAYER_BACKPACK_TEXTURE, slotX, slotY, 0, 0, 18, 18);
            }
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HOTBAR_TEXTURE);
        int hotbarStartX = x + 26 - 18;
        int hotbarStartY = y + 142;
        for (int col = 0; col < 9; ++col) {
            int slotX = hotbarStartX + col * 18;
            int slotY = hotbarStartY;
            guiGraphics.m_280218_(HOTBAR_TEXTURE, slotX, slotY, 0, 0, 18, 18);
        }
        int resultX = x + 75;
        int resultY = y + 19;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotX = resultX + col * 18;
                int slotY = resultY + row * 18;
                guiGraphics.m_280218_(new ResourceLocation("mixing_cutting:textures/gui/container/recipes_design.png"), slotX, slotY, 0, 0, 18, 18);
            }
        }
        int outputX = x + 146;
        int outputY = y + 53;
        guiGraphics.m_280218_(new ResourceLocation("mixing_cutting:textures/gui/container/thing_design.png"), outputX, outputY, 0, 0, 18, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scaleX = x + 66;
        int scaleStartY = y + 20;
        int scaleEndY = y + 20 + 54;
        for (int i = 0; i <= 9; ++i) {
            int scaleY = scaleStartY + (scaleEndY - scaleStartY) * i / 10;
            guiGraphics.m_280509_(scaleX, scaleY, scaleX + 2, scaleY + 1, -1);
        }
        FluidStack fluid = ((MixCutTableMenu)this.f_97732_).getBlockEntity().getFluidTank().getFluid();
        if (!fluid.isEmpty()) {
            Fluid fluidType = fluid.getFluid();
            int tankCapacity = ((MixCutTableMenu)this.f_97732_).getBlockEntity().getFluidTank().getCapacity();
            int fluidAmount = fluid.getAmount();
            int fluidHeight = (int)(54.0f * ((float)fluidAmount / (float)tankCapacity));
            int fluidDrawY = y + 20 + (54 - fluidHeight);
            int tankBottomY = y + 20 + 54;
            int color = FluidColorRegistry.getColor(fluid);
            guiGraphics.m_280509_(x + 65, fluidDrawY, x + 72, tankBottomY, color | 0xFF000000);
        }
        this.renderAvailableRecipes(guiGraphics, x, y);
        this.renderSlider(guiGraphics, x, y);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderFluidTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderFluidTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOverFluidTank(mouseX, mouseY)) {
            FluidStack fluid = ((MixCutTableMenu)this.f_97732_).getBlockEntity().getFluidTank().getFluid();
            if (!fluid.isEmpty()) {
                Component fluidName = fluid.getDisplayName();
                int amount = fluid.getAmount();
                int capacity = ((MixCutTableMenu)this.f_97732_).getBlockEntity().getFluidTank().getCapacity();
                MutableComponent tooltip = Component.m_237110_((String)"tooltip.mixing_cutting.fluid_tank.info", (Object[])new Object[]{fluidName, amount, capacity});
                guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
            } else {
                MutableComponent emptyTooltip = Component.m_237115_((String)"tooltip.mixing_cutting.fluid_tank.empty");
                guiGraphics.m_280557_(this.f_96547_, (Component)emptyTooltip, mouseX, mouseY);
            }
        }
    }

    private boolean isMouseOverFluidTank(int mouseX, int mouseY) {
        return mouseX >= this.fluidTankX && mouseX < this.fluidTankX + this.fluidTankWidth && mouseY >= this.fluidTankY && mouseY < this.fluidTankY + this.fluidTankHeight;
    }

    private void renderAvailableRecipes(GuiGraphics guiGraphics, int x, int y) {
        if (((MixCutTableMenu)this.f_97732_).getBlockEntity() == null) {
            return;
        }
        List<MixCutRecipe> availableRecipes = ((MixCutTableMenu)this.f_97732_).getBlockEntity().getAvailableRecipes();
        int startIndex = ((MixCutTableMenu)this.f_97732_).getScrollOffset();
        int recipeSlotStartX = x + 76;
        int recipeSlotStartY = y + 20;
        for (int i = 0; i < this.recipeDisplayCount; ++i) {
            int recipeIndex = startIndex + i;
            int slotX = recipeSlotStartX + i % 3 * 18;
            int slotY = recipeSlotStartY + i / 3 * 18;
            if (recipeIndex >= availableRecipes.size()) continue;
            MixCutRecipe recipe = availableRecipes.get(recipeIndex);
            ItemStack resultItem = recipe.m_8043_(null).m_41777_();
            guiGraphics.m_280480_(resultItem, slotX + 1, slotY + 1);
            guiGraphics.m_280370_(this.f_96547_, resultItem, slotX + 1, slotY + 1);
        }
    }

    private void renderSlider(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SLIDER_TEXTURE);
        int sliderX = x + 130;
        int sliderY = y + 19 + this.calculateSliderPosition();
        guiGraphics.m_280218_(SLIDER_TEXTURE, sliderX, sliderY, 0, 0, 16, 10);
    }

    private int calculateSliderPosition() {
        int totalRecipes = ((MixCutTableMenu)this.f_97732_).getAvailableRecipeCount();
        if (totalRecipes <= this.recipeDisplayCount) {
            return 0;
        }
        int maxScrollOffset = totalRecipes - this.recipeDisplayCount;
        int currentScrollOffset = ((MixCutTableMenu)this.f_97732_).getScrollOffset();
        float scrollProgress = (float)currentScrollOffset / (float)maxScrollOffset;
        int sliderMoveRange = 45;
        return (int)(scrollProgress * (float)sliderMoveRange);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOverRecipeSlot(mouseX, mouseY)) {
            this.handleRecipeSlotClick(mouseX, mouseY);
            return true;
        }
        if (this.isMouseOverSlider(mouseX, mouseY)) {
            this.isDraggingSlider = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDraggingSlider) {
            this.isDraggingSlider = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingSlider) {
            this.handleSliderDrag(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void handleRecipeSlotClick(double mouseX, double mouseY) {
        List<MixCutRecipe> availableRecipes;
        int guiX = (this.f_96543_ - this.f_97726_) / 2;
        int guiY = (this.f_96544_ - this.f_97727_) / 2;
        int recipeSlotStartX = guiX + 76;
        int recipeSlotStartY = guiY + 19;
        int clickedCol = (int)((mouseX - (double)recipeSlotStartX) / 18.0);
        int clickedRow = (int)((mouseY - (double)recipeSlotStartY) / 18.0);
        int slotIndex = clickedRow * 3 + clickedCol;
        int recipeIndex = ((MixCutTableMenu)this.f_97732_).getScrollOffset() + slotIndex;
        if (recipeIndex < (availableRecipes = ((MixCutTableMenu)this.f_97732_).getBlockEntity().getAvailableRecipes()).size()) {
            MixCutRecipe selectedRecipe = availableRecipes.get(recipeIndex);
            String recipeId = selectedRecipe.getRecipeId();
            Networking.CHANNEL.sendToServer((Object)new SelectRecipePacket(((MixCutTableMenu)this.f_97732_).getBlockEntity().m_58899_(), selectedRecipe.getRecipeId()));
            ((MixCutTableMenu)this.f_97732_).selectRecipeClientSide(recipeId);
        }
    }

    private void handleSliderDrag(double mouseY) {
        int guiX = (this.f_96543_ - this.f_97726_) / 2;
        int guiY = (this.f_96544_ - this.f_97727_) / 2;
        int sliderAreaTop = guiY + 24;
        int sliderAreaBottom = guiY + 20 + 44;
        float dragProgress = (float)(mouseY - (double)sliderAreaTop) / (float)(sliderAreaBottom - sliderAreaTop);
        dragProgress = Math.max(0.0f, Math.min(1.0f, dragProgress));
        int totalRecipes = ((MixCutTableMenu)this.f_97732_).getAvailableRecipeCount();
        int maxScrollOffset = Math.max(0, totalRecipes - this.recipeDisplayCount);
        int newScrollOffset = (int)(dragProgress * (float)maxScrollOffset);
        ((MixCutTableMenu)this.f_97732_).setScrollOffset(newScrollOffset);
    }

    private boolean isMouseOverRecipeSlot(double mouseX, double mouseY) {
        int guiX = (this.f_96543_ - this.f_97726_) / 2;
        int guiY = (this.f_96544_ - this.f_97727_) / 2;
        int recipeAreaX1 = guiX + 76;
        int recipeAreaX2 = guiX + 76 + 53;
        int recipeAreaY1 = guiY + 20;
        int recipeAreaY2 = guiY + 20 + 53;
        return mouseX >= (double)recipeAreaX1 && mouseX < (double)recipeAreaX2 && mouseY >= (double)recipeAreaY1 && mouseY < (double)recipeAreaY2;
    }

    private boolean isMouseOverSlider(double mouseX, double mouseY) {
        int guiX = (this.f_96543_ - this.f_97726_) / 2;
        int guiY = (this.f_96544_ - this.f_97727_) / 2;
        int sliderX1 = guiX + 130;
        int sliderX2 = guiX + 130 + 16;
        int sliderY1 = guiY + 19 + this.calculateSliderPosition();
        int sliderY2 = guiY + 20 + this.calculateSliderPosition() + 10;
        return mouseX >= (double)sliderX1 && mouseX < (double)sliderX2 && mouseY >= (double)sliderY1 && mouseY < (double)sliderY2;
    }
}

